/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.memory.BaseAllocator;

public class JdbcToArrowConfigBuilder {
    private Calendar calendar = null;
    private BaseAllocator allocator = null;
    private boolean includeMetadata = false;
    private Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex = null;
    private Map<String, JdbcFieldInfo> arraySubTypesByColumnName = null;

    public JdbcToArrowConfigBuilder() {
    }

    public JdbcToArrowConfigBuilder(BaseAllocator allocator, Calendar calendar) {
        this();
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        this.calendar = calendar;
        this.includeMetadata = false;
    }

    public JdbcToArrowConfigBuilder(BaseAllocator allocator, Calendar calendar, boolean includeMetadata) {
        this(allocator, calendar);
        this.includeMetadata = includeMetadata;
    }

    public JdbcToArrowConfigBuilder setAllocator(BaseAllocator allocator) {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        return this;
    }

    public JdbcToArrowConfigBuilder setCalendar(Calendar calendar) {
        this.calendar = calendar;
        return this;
    }

    public JdbcToArrowConfigBuilder setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
        return this;
    }

    public JdbcToArrowConfigBuilder setArraySubTypeByColumnIndexMap(Map<Integer, JdbcFieldInfo> map) {
        this.arraySubTypesByColumnIndex = map;
        return this;
    }

    public JdbcToArrowConfigBuilder setArraySubTypeByColumnNameMap(Map<String, JdbcFieldInfo> map) {
        this.arraySubTypesByColumnName = map;
        return this;
    }

    public JdbcToArrowConfig build() {
        return new JdbcToArrowConfig(this.allocator, this.calendar, this.includeMetadata, this.arraySubTypesByColumnIndex, this.arraySubTypesByColumnName);
    }
}

