/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.google.common.base.Preconditions;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcFieldInfo {
    private final int jdbcType;
    private final int precision;
    private final int scale;

    public JdbcFieldInfo(int jdbcType) {
        Preconditions.checkArgument((jdbcType != 3 && jdbcType != 2 ? 1 : 0) != 0, (Object)"DECIMAL and NUMERIC types require a precision and scale; please use another constructor.");
        this.jdbcType = jdbcType;
        this.precision = 0;
        this.scale = 0;
    }

    public JdbcFieldInfo(int jdbcType, int precision, int scale) {
        this.jdbcType = jdbcType;
        this.precision = precision;
        this.scale = scale;
    }

    public JdbcFieldInfo(ResultSetMetaData rsmd, int column) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"ResultSetMetaData cannot be null.");
        Preconditions.checkArgument((column > 0 ? 1 : 0) != 0, (Object)"ResultSetMetaData columns have indices starting at 1.");
        Preconditions.checkArgument((column <= rsmd.getColumnCount() ? 1 : 0) != 0, (String)"The index must be within the number of columns (1 to %s, inclusive)", (int)rsmd.getColumnCount());
        this.jdbcType = rsmd.getColumnType(column);
        this.precision = rsmd.getPrecision(column);
        this.scale = rsmd.getScale(column);
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }
}

