/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.example.ExampleTicket;
import org.apache.arrow.flight.example.Stream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DictionaryUtility;

public class FlightHolder
implements AutoCloseable {
    private final BufferAllocator allocator;
    private final FlightDescriptor descriptor;
    private final Schema schema;
    private final List<Stream> streams = new CopyOnWriteArrayList<Stream>();
    private final DictionaryProvider dictionaryProvider;

    public FlightHolder(BufferAllocator allocator, FlightDescriptor descriptor, Schema schema, DictionaryProvider dictionaryProvider) {
        Preconditions.checkArgument((!descriptor.isCommand() ? 1 : 0) != 0);
        this.allocator = allocator.newChildAllocator(descriptor.toString(), 0L, Long.MAX_VALUE);
        this.descriptor = descriptor;
        this.schema = schema;
        this.dictionaryProvider = dictionaryProvider;
    }

    public Stream getStream(ExampleTicket ticket) {
        Preconditions.checkArgument((ticket.getOrdinal() < this.streams.size() ? 1 : 0) != 0, (Object)"Unknown stream.");
        Stream stream = this.streams.get(ticket.getOrdinal());
        stream.verify(ticket);
        return stream;
    }

    public Stream.StreamCreator addStream(Schema schema) {
        Preconditions.checkArgument((boolean)this.schema.equals((Object)schema), (Object)"Stream schema inconsistent with existing schema.");
        return new Stream.StreamCreator(schema, this.dictionaryProvider, this.allocator, t -> {
            List<Stream> list = this.streams;
            synchronized (list) {
                this.streams.add((Stream)t);
            }
        });
    }

    public FlightInfo getFlightInfo(Location l) {
        long bytes = this.allocator.getAllocatedMemory();
        long records = this.streams.stream().collect(Collectors.summingLong(t -> t.getRecordCount()));
        ArrayList<FlightEndpoint> endpoints = new ArrayList<FlightEndpoint>();
        int i = 0;
        for (Stream s : this.streams) {
            endpoints.add(new FlightEndpoint(new ExampleTicket(this.descriptor.getPath(), i, s.getUuid()).toTicket(), l));
            ++i;
        }
        return new FlightInfo(this.schema, this.descriptor, endpoints, bytes, records);
    }

    @Override
    public void close() throws Exception {
        HashSet dictionaryIds = new HashSet();
        this.schema.getFields().forEach(field -> DictionaryUtility.toMessageFormat((Field)field, (DictionaryProvider)this.dictionaryProvider, (Set)dictionaryIds));
        Iterable dictionaries = dictionaryIds.stream().map(id -> this.dictionaryProvider.lookup(id.longValue()).getVector())::iterator;
        AutoCloseables.close((Iterable)Iterables.concat(this.streams, (Iterable)ImmutableList.of((Object)this.allocator), dictionaries));
    }
}

