/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightService;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.memory.BufferAllocator;

class FlightBindingService
implements BindableService {
    private static final String DO_GET = MethodDescriptor.generateFullMethodName((String)"arrow.flight.protocol.FlightService", (String)"DoGet");
    private static final String DO_PUT = MethodDescriptor.generateFullMethodName((String)"arrow.flight.protocol.FlightService", (String)"DoPut");
    private static final Set<String> OVERRIDE_METHODS = ImmutableSet.of((Object)DO_GET, (Object)DO_PUT);
    private final FlightService delegate;
    private final BufferAllocator allocator;

    public FlightBindingService(BufferAllocator allocator, FlightProducer producer, ServerAuthHandler authHandler, ExecutorService executor) {
        this.allocator = allocator;
        this.delegate = new FlightService(allocator, producer, authHandler, executor);
    }

    public static MethodDescriptor<Flight.Ticket, ArrowMessage> getDoGetDescriptor(BufferAllocator allocator) {
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(DO_GET).setSampledToLocalTracing(false).setRequestMarshaller(ProtoUtils.marshaller((Message)Flight.Ticket.getDefaultInstance())).setResponseMarshaller(ArrowMessage.createMarshaller(allocator)).build();
    }

    public static MethodDescriptor<ArrowMessage, Flight.PutResult> getDoPutDescriptor(BufferAllocator allocator) {
        return MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(DO_PUT).setSampledToLocalTracing(false).setRequestMarshaller(ArrowMessage.createMarshaller(allocator)).setResponseMarshaller(ProtoUtils.marshaller((Message)Flight.PutResult.getDefaultInstance())).build();
    }

    public ServerServiceDefinition bindService() {
        ServerServiceDefinition baseDefinition = this.delegate.bindService();
        MethodDescriptor<Flight.Ticket, ArrowMessage> doGetDescriptor = FlightBindingService.getDoGetDescriptor(this.allocator);
        MethodDescriptor<ArrowMessage, Flight.PutResult> doPutDescriptor = FlightBindingService.getDoPutDescriptor(this.allocator);
        ServerServiceDefinition.Builder serviceBuilder = ServerServiceDefinition.builder((String)"arrow.flight.protocol.FlightService");
        serviceBuilder.addMethod(doGetDescriptor, ServerCalls.asyncServerStreamingCall((ServerCalls.ServerStreamingMethod)new DoGetMethod(this.delegate)));
        serviceBuilder.addMethod(doPutDescriptor, ServerCalls.asyncBidiStreamingCall((ServerCalls.BidiStreamingMethod)new DoPutMethod(this.delegate)));
        for (ServerMethodDefinition definition : baseDefinition.getMethods()) {
            if (OVERRIDE_METHODS.contains(definition.getMethodDescriptor().getFullMethodName())) continue;
            serviceBuilder.addMethod(definition);
        }
        return serviceBuilder.build();
    }

    private class DoPutMethod
    implements ServerCalls.BidiStreamingMethod<ArrowMessage, Flight.PutResult> {
        private final FlightService delegate;

        public DoPutMethod(FlightService delegate) {
            this.delegate = delegate;
        }

        public StreamObserver<ArrowMessage> invoke(StreamObserver<Flight.PutResult> responseObserver) {
            return this.delegate.doPutCustom(responseObserver);
        }
    }

    private class DoGetMethod
    implements ServerCalls.ServerStreamingMethod<Flight.Ticket, ArrowMessage> {
        private final FlightService delegate;

        public DoGetMethod(FlightService delegate) {
            this.delegate = delegate;
        }

        public void invoke(Flight.Ticket request, StreamObserver<ArrowMessage> responseObserver) {
            this.delegate.doGetCustom(request, responseObserver);
        }
    }
}

