/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example.integration;

import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.example.ExampleFlightServer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegrationTestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestServer.class);
    private final Options options = new Options();

    private IntegrationTestServer() {
        this.options.addOption("port", true, "The port to serve on.");
    }

    private void run(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        int port = Integer.parseInt(cmd.getOptionValue("port", "31337"));
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        ExampleFlightServer efs = new ExampleFlightServer((BufferAllocator)allocator, Location.forGrpcInsecure("localhost", port));
        efs.start();
        System.out.println("Server listening on localhost:" + port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> IntegrationTestServer.lambda$run$0(efs, (BufferAllocator)allocator)));
        efs.awaitTermination();
    }

    public static void main(String[] args) {
        try {
            new IntegrationTestServer().run(args);
        }
        catch (ParseException e) {
            IntegrationTestServer.fatalError("Error parsing arguments", e);
        }
        catch (Exception e) {
            IntegrationTestServer.fatalError("Runtime error", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private static /* synthetic */ void lambda$run$0(ExampleFlightServer efs, BufferAllocator allocator) {
        try {
            System.out.println("\nExiting...");
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{efs, allocator});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

