/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import org.apache.arrow.flight.FlightProducer;

class StreamPipe<FROM, TO>
implements FlightProducer.StreamListener<FROM> {
    private StreamObserver<TO> delegate;
    private Function<FROM, TO> mapFunction;

    public static <FROM, TO> FlightProducer.StreamListener<FROM> wrap(StreamObserver<TO> delegate, Function<FROM, TO> func) {
        return new StreamPipe<FROM, TO>(delegate, func);
    }

    public StreamPipe(StreamObserver<TO> delegate, Function<FROM, TO> func) {
        this.delegate = delegate;
        this.mapFunction = func;
    }

    @Override
    public void onNext(FROM val) {
        this.delegate.onNext(this.mapFunction.apply(val));
    }

    @Override
    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    @Override
    public void onCompleted() {
        this.delegate.onCompleted();
    }
}

