/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.protobuf.ByteString;
import io.netty.buffer.ArrowBuf;
import java.nio.ByteBuffer;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.memory.BufferAllocator;

public class PutResult
implements AutoCloseable {
    private ArrowBuf applicationMetadata;

    private PutResult(ArrowBuf metadata) {
        this.applicationMetadata = metadata;
    }

    public static PutResult metadata(ArrowBuf metadata) {
        if (metadata == null) {
            return PutResult.empty();
        }
        return new PutResult(metadata);
    }

    public static PutResult empty() {
        return new PutResult(null);
    }

    public ArrowBuf getApplicationMetadata() {
        return this.applicationMetadata;
    }

    Flight.PutResult toProtocol() {
        if (this.applicationMetadata == null) {
            return Flight.PutResult.getDefaultInstance();
        }
        return Flight.PutResult.newBuilder().setAppMetadata(ByteString.copyFrom((ByteBuffer)this.applicationMetadata.nioBuffer())).build();
    }

    static PutResult fromProtocol(BufferAllocator allocator, Flight.PutResult message) {
        ArrowBuf buf = allocator.buffer(message.getAppMetadata().size());
        message.getAppMetadata().asReadOnlyByteBufferList().forEach(bb -> {
            buf.setBytes(buf.writerIndex(), bb);
            buf.writerIndex(buf.writerIndex() + bb.limit());
        });
        return new PutResult(buf);
    }

    @Override
    public void close() {
        if (this.applicationMetadata != null) {
            this.applicationMetadata.close();
        }
    }
}

