/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.arrow.flight.impl.Flight;

public class Location {
    private final URI uri;

    public Location(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public Location(URI uri) {
        this.uri = uri;
        switch (uri.getScheme()) {
            case "grpc": 
            case "grpc+unix": 
            case "grpc+tcp": 
            case "grpc+tls": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Scheme is not supported: " + this.uri);
            }
        }
    }

    public URI getUri() {
        return this.uri;
    }

    SocketAddress toSocketAddress() {
        switch (this.uri.getScheme()) {
            case "grpc": 
            case "grpc+tls": 
            case "grpc+tcp": {
                return new InetSocketAddress(this.uri.getHost(), this.uri.getPort());
            }
            case "grpc+unix": {
                try {
                    return (SocketAddress)Class.forName("io.netty.channel.unix.DomainSocketAddress").getConstructor(String.class).newInstance(this.uri.getPath());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public Flight.Location toProtocol() {
        return Flight.Location.newBuilder().setUri(this.uri.toString()).build();
    }

    public static Location forGrpcInsecure(String host, int port) {
        try {
            return new Location(new URI("grpc+tcp", null, host, port, null, null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Location forGrpcTls(String host, int port) {
        try {
            return new Location(new URI("grpc+tls", null, host, port, null, null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Location forGrpcDomainSocket(String path) {
        try {
            return new Location(new URI("grpc+unix", null, path, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

