/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.impl.Flight;

public class FlightEndpoint {
    private List<Location> locations;
    private Ticket ticket;

    public FlightEndpoint(Ticket ticket, Location ... locations) {
        this.locations = ImmutableList.copyOf((Object[])locations);
        this.ticket = ticket;
    }

    public FlightEndpoint(Flight.FlightEndpoint flt) throws URISyntaxException {
        this.locations = new ArrayList<Location>();
        for (Flight.Location location : flt.getLocationList()) {
            this.locations.add(new Location(location.getUri()));
        }
        this.ticket = new Ticket(flt.getTicket());
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    Flight.FlightEndpoint toProtocol() {
        Flight.FlightEndpoint.Builder b = Flight.FlightEndpoint.newBuilder().setTicket(this.ticket.toProtocol());
        for (Location l : this.locations) {
            b.addLocation(l.toProtocol());
        }
        return b.build();
    }
}

