/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.netty.buffer.ArrowBuf;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.ActionType;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallOptions;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.DictionaryUtils;
import org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpStreamListener;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.auth.BasicClientAuthHandler;
import org.apache.arrow.flight.auth.ClientAuthHandler;
import org.apache.arrow.flight.auth.ClientAuthInterceptor;
import org.apache.arrow.flight.auth.ClientAuthWrapper;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.impl.FlightServiceGrpc;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;

public class FlightClient
implements AutoCloseable {
    private static final int PENDING_REQUESTS = 5;
    private static final int MAX_CHANNEL_TRACE_EVENTS = 0;
    private final BufferAllocator allocator;
    private final ManagedChannel channel;
    private final FlightServiceGrpc.FlightServiceBlockingStub blockingStub;
    private final FlightServiceGrpc.FlightServiceStub asyncStub;
    private final ClientAuthInterceptor authInterceptor = new ClientAuthInterceptor();
    private final MethodDescriptor<Flight.Ticket, ArrowMessage> doGetDescriptor;
    private final MethodDescriptor<ArrowMessage, Flight.PutResult> doPutDescriptor;

    private FlightClient(BufferAllocator incomingAllocator, ManagedChannel channel) {
        this.allocator = incomingAllocator.newChildAllocator("flight-client", 0L, Long.MAX_VALUE);
        this.channel = channel;
        this.blockingStub = (FlightServiceGrpc.FlightServiceBlockingStub)FlightServiceGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{this.authInterceptor});
        this.asyncStub = (FlightServiceGrpc.FlightServiceStub)FlightServiceGrpc.newStub((Channel)channel).withInterceptors(new ClientInterceptor[]{this.authInterceptor});
        this.doGetDescriptor = FlightBindingService.getDoGetDescriptor(this.allocator);
        this.doPutDescriptor = FlightBindingService.getDoPutDescriptor(this.allocator);
    }

    public Iterable<FlightInfo> listFlights(Criteria criteria, CallOption ... options) {
        return ImmutableList.copyOf(CallOptions.wrapStub(this.blockingStub, options).listFlights(criteria.asCriteria())).stream().map(t -> {
            try {
                return new FlightInfo((Flight.FlightInfo)t);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public Iterable<ActionType> listActions(CallOption ... options) {
        return ImmutableList.copyOf(CallOptions.wrapStub(this.blockingStub, options).listActions(Flight.Empty.getDefaultInstance())).stream().map(ActionType::new).collect(Collectors.toList());
    }

    public Iterator<Result> doAction(Action action, CallOption ... options) {
        return Iterators.transform(CallOptions.wrapStub(this.blockingStub, options).doAction(action.toProtocol()), Result::new);
    }

    public void authenticateBasic(String username, String password) {
        BasicClientAuthHandler basicClient = new BasicClientAuthHandler(username, password);
        this.authenticate(basicClient, new CallOption[0]);
    }

    public void authenticate(ClientAuthHandler handler, CallOption ... options) {
        Preconditions.checkArgument((!this.authInterceptor.hasAuthHandler() ? 1 : 0) != 0, (Object)"Auth already completed.");
        ClientAuthWrapper.doClientAuth(handler, CallOptions.wrapStub(this.asyncStub, options));
        this.authInterceptor.setAuthHandler(handler);
    }

    public ClientStreamListener startPut(FlightDescriptor descriptor, VectorSchemaRoot root, PutListener metadataListener, CallOption ... options) {
        return this.startPut(descriptor, root, (DictionaryProvider)new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]), metadataListener, options);
    }

    public ClientStreamListener startPut(FlightDescriptor descriptor, VectorSchemaRoot root, DictionaryProvider provider, PutListener metadataListener, CallOption ... options) {
        Preconditions.checkNotNull((Object)descriptor);
        Preconditions.checkNotNull((Object)root);
        SetStreamObserver resultObserver = new SetStreamObserver(this.allocator, metadataListener);
        io.grpc.CallOptions callOptions = CallOptions.wrapStub(this.asyncStub, options).getCallOptions();
        ClientCallStreamObserver observer = (ClientCallStreamObserver)ClientCalls.asyncBidiStreamingCall(this.authInterceptor.interceptCall(this.doPutDescriptor, callOptions, (Channel)this.channel), (StreamObserver)resultObserver);
        DictionaryUtils.generateSchemaMessages(root.getSchema(), descriptor, provider, arg_0 -> ((ClientCallStreamObserver)observer).onNext(arg_0));
        return new PutObserver(new VectorUnloader(root, true, true), (ClientCallStreamObserver<ArrowMessage>)observer, metadataListener);
    }

    public FlightInfo getInfo(FlightDescriptor descriptor, CallOption ... options) {
        try {
            return new FlightInfo(CallOptions.wrapStub(this.blockingStub, options).getFlightInfo(descriptor.toProtocol()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public FlightStream getStream(Ticket ticket, CallOption ... options) {
        io.grpc.CallOptions callOptions = CallOptions.wrapStub(this.asyncStub, options).getCallOptions();
        ClientCall<Flight.Ticket, ArrowMessage> call = this.authInterceptor.interceptCall(this.doGetDescriptor, callOptions, (Channel)this.channel);
        FlightStream stream = new FlightStream(this.allocator, 5, (message, cause) -> call.cancel(message, cause), count -> call.request(count));
        final StreamObserver<ArrowMessage> delegate = stream.asObserver();
        ClientResponseObserver<Flight.Ticket, ArrowMessage> clientResponseObserver = new ClientResponseObserver<Flight.Ticket, ArrowMessage>(){

            public void beforeStart(ClientCallStreamObserver<Flight.Ticket> requestStream) {
                requestStream.disableAutoInboundFlowControl();
            }

            public void onNext(ArrowMessage value) {
                delegate.onNext((Object)value);
            }

            public void onError(Throwable t) {
                delegate.onError(t);
            }

            public void onCompleted() {
                delegate.onCompleted();
            }
        };
        ClientCalls.asyncServerStreamingCall(call, (Object)ticket.toProtocol(), (StreamObserver)clientResponseObserver);
        return stream;
    }

    @Override
    public void close() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        this.allocator.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BufferAllocator allocator, Location location) {
        return new Builder(allocator, location);
    }

    public static final class Builder {
        private BufferAllocator allocator;
        private Location location;
        private boolean forceTls = false;
        private int maxInboundMessageSize = Integer.MAX_VALUE;
        private InputStream trustedCertificates = null;
        private InputStream clientCertificate = null;
        private InputStream clientKey = null;
        private String overrideHostname = null;

        private Builder() {
        }

        private Builder(BufferAllocator allocator, Location location) {
            this.allocator = (BufferAllocator)Preconditions.checkNotNull((Object)allocator);
            this.location = (Location)Preconditions.checkNotNull((Object)location);
        }

        public Builder useTls() {
            this.forceTls = true;
            return this;
        }

        public Builder overrideHostname(String hostname) {
            this.overrideHostname = hostname;
            return this;
        }

        public Builder maxInboundMessageSize(int maxSize) {
            Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
            this.maxInboundMessageSize = maxSize;
            return this;
        }

        public Builder trustedCertificates(InputStream stream) {
            this.trustedCertificates = (InputStream)Preconditions.checkNotNull((Object)stream);
            return this;
        }

        public Builder clientCertificate(InputStream clientCertificate, InputStream clientKey) {
            Preconditions.checkNotNull((Object)clientKey);
            this.clientCertificate = (InputStream)Preconditions.checkNotNull((Object)clientCertificate);
            this.clientKey = (InputStream)Preconditions.checkNotNull((Object)clientKey);
            return this;
        }

        public Builder allocator(BufferAllocator allocator) {
            this.allocator = (BufferAllocator)Preconditions.checkNotNull((Object)allocator);
            return this;
        }

        public Builder location(Location location) {
            this.location = (Location)Preconditions.checkNotNull((Object)location);
            return this;
        }

        public FlightClient build() {
            NettyChannelBuilder builder;
            switch (this.location.getUri().getScheme()) {
                case "grpc": 
                case "grpc+tcp": 
                case "grpc+tls": {
                    builder = NettyChannelBuilder.forAddress((SocketAddress)this.location.toSocketAddress());
                    break;
                }
                case "grpc+unix": {
                    builder = NettyChannelBuilder.forAddress((SocketAddress)this.location.toSocketAddress());
                    try {
                        try {
                            builder.channelType(Class.forName("io.netty.channel.epoll.EpollDomainSocketChannel"));
                            EventLoopGroup elg = (EventLoopGroup)Class.forName("io.netty.channel.epoll.EpollEventLoopGroup").newInstance();
                            builder.eventLoopGroup(elg);
                        }
                        catch (ClassNotFoundException e) {
                            builder.channelType(Class.forName("io.netty.channel.kqueue.KQueueDomainSocketChannel"));
                            EventLoopGroup elg = (EventLoopGroup)Class.forName("io.netty.channel.kqueue.KQueueEventLoopGroup").newInstance();
                            builder.eventLoopGroup(elg);
                        }
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new UnsupportedOperationException("Could not find suitable Netty native transport implementation for domain socket address.");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Scheme is not supported: " + this.location.getUri().getScheme());
                }
            }
            if (this.forceTls || "grpc+tls".equals(this.location.getUri().getScheme())) {
                builder.useTransportSecurity();
                if (this.trustedCertificates != null || this.clientCertificate != null || this.clientKey != null) {
                    SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                    if (this.trustedCertificates != null) {
                        sslContextBuilder.trustManager(this.trustedCertificates);
                    }
                    if (this.clientCertificate != null && this.clientKey != null) {
                        sslContextBuilder.keyManager(this.clientCertificate, this.clientKey);
                    }
                    try {
                        builder.sslContext(sslContextBuilder.build());
                    }
                    catch (SSLException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.overrideHostname != null) {
                    builder.overrideAuthority(this.overrideHostname);
                }
            } else {
                builder.usePlaintext();
            }
            ((NettyChannelBuilder)builder.maxTraceEvents(0)).maxInboundMessageSize(this.maxInboundMessageSize);
            return new FlightClient(this.allocator, builder.build());
        }
    }

    public static interface PutListener
    extends FlightProducer.StreamListener<PutResult> {
        public void getResult();

        @Override
        public void onNext(PutResult var1);
    }

    public static interface ClientStreamListener {
        public void putNext();

        public void putNext(ArrowBuf var1);

        public void error(Throwable var1);

        public void completed();

        public void getResult();
    }

    private static class PutObserver
    implements ClientStreamListener {
        private final ClientCallStreamObserver<ArrowMessage> observer;
        private final VectorUnloader unloader;
        private final PutListener listener;

        public PutObserver(VectorUnloader unloader, ClientCallStreamObserver<ArrowMessage> observer, PutListener listener) {
            this.observer = observer;
            this.unloader = unloader;
            this.listener = listener;
        }

        @Override
        public void putNext() {
            this.putNext(null);
        }

        @Override
        public void putNext(ArrowBuf appMetadata) {
            ArrowRecordBatch batch = this.unloader.getRecordBatch();
            while (!this.observer.isReady()) {
            }
            this.observer.onNext((Object)new ArrowMessage(batch, appMetadata));
        }

        @Override
        public void error(Throwable ex) {
            this.observer.onError(ex);
        }

        @Override
        public void completed() {
            this.observer.onCompleted();
        }

        @Override
        public void getResult() {
            this.listener.getResult();
        }
    }

    private static class SetStreamObserver
    implements StreamObserver<Flight.PutResult> {
        private final BufferAllocator allocator;
        private final FlightProducer.StreamListener<PutResult> listener;

        SetStreamObserver(BufferAllocator allocator, FlightProducer.StreamListener<PutResult> listener) {
            this.allocator = allocator;
            this.listener = listener == null ? NoOpStreamListener.getInstance() : listener;
        }

        public void onNext(Flight.PutResult value) {
            try (PutResult message = PutResult.fromProtocol(this.allocator, value);){
                this.listener.onNext(message);
            }
        }

        public void onError(Throwable t) {
            this.listener.onError(t);
        }

        public void onCompleted() {
            this.listener.onCompleted();
        }
    }
}

