/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.example.ExampleTicket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;

public class Stream
implements AutoCloseable,
Iterable<ArrowRecordBatch> {
    private final String uuid = UUID.randomUUID().toString();
    private final List<ArrowRecordBatch> batches;
    private final Schema schema;
    private final long recordCount;

    public Stream(Schema schema, List<ArrowRecordBatch> batches, long recordCount) {
        this.schema = schema;
        this.batches = ImmutableList.copyOf(batches);
        this.recordCount = recordCount;
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Iterator<ArrowRecordBatch> iterator() {
        return this.batches.iterator();
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void sendTo(BufferAllocator allocator, FlightProducer.ServerStreamListener listener) {
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)this.schema, (BufferAllocator)allocator);){
            listener.start(root);
            VectorLoader loader = new VectorLoader(root);
            for (ArrowRecordBatch batch : this.batches) {
                loader.load(batch);
                listener.putNext();
            }
            listener.completed();
        }
        catch (Exception ex) {
            listener.error(ex);
        }
    }

    public void verify(ExampleTicket ticket) {
        if (!this.uuid.equals(ticket.getUuid())) {
            throw new IllegalStateException("Ticket doesn't match.");
        }
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.batches);
    }

    public static class StreamCreator {
        private final Schema schema;
        private final BufferAllocator allocator;
        private final List<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        private final Consumer<Stream> committer;
        private long recordCount = 0L;

        public StreamCreator(Schema schema, BufferAllocator allocator, Consumer<Stream> committer) {
            this.allocator = allocator;
            this.committer = committer;
            this.schema = schema;
        }

        public void drop() {
            try {
                AutoCloseables.close(this.batches);
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }

        public void add(ArrowRecordBatch batch) {
            this.batches.add(batch.cloneWithTransfer(this.allocator));
            this.recordCount += (long)batch.getLength();
        }

        public void complete() {
            Stream stream = new Stream(this.schema, this.batches, this.recordCount);
            this.committer.accept(stream);
        }
    }
}

