/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.apache.arrow.flight.auth.AuthConstants;

public class ClientAuthInterceptor
implements ClientInterceptor {
    private volatile Metadata headerWithAuth;

    public void setToken(byte[] token) {
        Metadata md = new Metadata();
        md.put(AuthConstants.TOKEN_KEY, (Object)token);
        this.headerWithAuth = md;
    }

    public boolean hasToken() {
        return this.headerWithAuth != null;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel next) {
        Object call = next.newCall(methodDescriptor, callOptions);
        if (this.headerWithAuth != null) {
            call = new HeaderAttachingClientCall((ClientCall)call);
        }
        return call;
    }

    private final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
            super(call);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            headers.merge(ClientAuthInterceptor.this.headerWithAuth);
            super.start(responseListener, headers);
        }
    }
}

