/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.grpc;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AddWritableBuffer {
    private static final Constructor<?> bufConstruct;
    private static final Field bufferList;
    private static final Field current;
    private static final Method listAdd;
    private static final Class<?> bufChainOut;

    public static boolean add(ByteBuf buf, OutputStream stream) throws IOException {
        buf.readBytes(stream, buf.readableBytes());
        if (bufChainOut == null) {
            return false;
        }
        if (!stream.getClass().equals(bufChainOut)) {
            return false;
        }
        try {
            if (current.get(stream) != null) {
                return false;
            }
            buf.retain();
            Object obj = bufConstruct.newInstance(buf);
            Object list = bufferList.get(stream);
            listAdd.invoke(list, obj);
            current.set(stream, obj);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        Constructor<?> tmpConstruct = null;
        Field tmpBufferList = null;
        Field tmpCurrent = null;
        Class<?> tmpBufChainOut = null;
        Method tmpListAdd = null;
        try {
            Class<?> nwb = Class.forName("io.grpc.netty.NettyWritableBuffer");
            Constructor<?> tmpConstruct2 = nwb.getDeclaredConstructor(ByteBuf.class);
            tmpConstruct2.setAccessible(true);
            Class<?> tmpBufChainOut2 = Class.forName("io.grpc.internal.MessageFramer$BufferChainOutputStream");
            Field tmpBufferList2 = tmpBufChainOut2.getDeclaredField("bufferList");
            tmpBufferList2.setAccessible(true);
            Field tmpCurrent2 = tmpBufChainOut2.getDeclaredField("current");
            tmpCurrent2.setAccessible(true);
            Method tmpListAdd2 = List.class.getDeclaredMethod("add", Object.class);
            tmpConstruct = tmpConstruct2;
            tmpBufferList = tmpBufferList2;
            tmpCurrent = tmpCurrent2;
            tmpListAdd = tmpListAdd2;
            tmpBufChainOut = tmpBufChainOut2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        bufConstruct = tmpConstruct;
        bufferList = tmpBufferList;
        current = tmpCurrent;
        listAdd = tmpListAdd;
        bufChainOut = tmpBufChainOut;
    }
}

