/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightInfo {
    private Schema schema;
    private FlightDescriptor descriptor;
    private List<FlightEndpoint> endpoints;
    private final long bytes;
    private final long records;

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records) {
        this.schema = schema;
        this.descriptor = descriptor;
        this.endpoints = endpoints;
        this.bytes = bytes;
        this.records = records;
    }

    FlightInfo(Flight.FlightGetInfo flightGetInfo) {
        this.schema = flightGetInfo.getSchema().size() > 0 ? Schema.deserialize((ByteBuffer)flightGetInfo.getSchema().asReadOnlyByteBuffer()) : new Schema((Iterable)ImmutableList.of());
        this.descriptor = new FlightDescriptor(flightGetInfo.getFlightDescriptor());
        this.endpoints = flightGetInfo.getEndpointList().stream().map(t -> new FlightEndpoint((Flight.FlightEndpoint)t)).collect(Collectors.toList());
        this.bytes = flightGetInfo.getTotalBytes();
        this.records = flightGetInfo.getTotalRecords();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getRecords() {
        return this.records;
    }

    public FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<FlightEndpoint> getEndpoints() {
        return this.endpoints;
    }

    Flight.FlightGetInfo toProtocol() {
        return Flight.FlightGetInfo.newBuilder().addAllEndpoint(this.endpoints.stream().map(t -> t.toProtocol()).collect(Collectors.toList())).setSchema(ByteString.copyFrom((byte[])this.schema.toByteArray())).setFlightDescriptor(this.descriptor.toProtocol()).setTotalBytes(this.bytes).setTotalRecords(this.records).build();
    }
}

