/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.Data;
import org.apache.arrow.dataset.jni.JniWrapper;
import org.apache.arrow.dataset.jni.NativeContext;
import org.apache.arrow.dataset.jni.NativeInstanceReleasedException;
import org.apache.arrow.dataset.jni.NativeScanTask;
import org.apache.arrow.dataset.scanner.Scanner;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.SchemaUtility;

public class NativeScanner
implements Scanner {
    private final AtomicBoolean executed = new AtomicBoolean(false);
    private final NativeContext context;
    private final long scannerId;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();
    private boolean closed = false;

    public NativeScanner(NativeContext context, long scannerId) {
        this.context = context;
        this.scannerId = scannerId;
    }

    ArrowReader execute() {
        if (this.closed) {
            throw new NativeInstanceReleasedException();
        }
        if (!this.executed.compareAndSet(false, true)) {
            throw new UnsupportedOperationException("NativeScanner cannot be executed more than once. Consider creating new scanner instead");
        }
        return new NativeReader(this.context.getAllocator());
    }

    public Iterable<? extends NativeScanTask> scan() {
        if (this.closed) {
            throw new NativeInstanceReleasedException();
        }
        return Collections.singletonList(new NativeScanTask(this));
    }

    @Override
    public Schema schema() {
        this.readLock.lock();
        try {
            if (this.closed) {
                throw new NativeInstanceReleasedException();
            }
            Schema schema = SchemaUtility.deserialize((byte[])JniWrapper.get().getSchemaFromScanner(this.scannerId), (BufferAllocator)this.context.getAllocator());
            return schema;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() {
        this.writeLock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            JniWrapper.get().closeScanner(this.scannerId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public class NativeReader
    extends ArrowReader {
        private NativeReader(BufferAllocator allocator) {
            super(allocator);
        }

        protected void loadRecordBatch(ArrowRecordBatch batch) {
            throw new UnsupportedOperationException();
        }

        protected void loadDictionary(ArrowDictionaryBatch dictionaryBatch) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean loadNextBatch() throws IOException {
            NativeScanner.this.readLock.lock();
            try {
                if (NativeScanner.this.closed) {
                    throw new NativeInstanceReleasedException();
                }
                try (ArrowArray arrowArray = ArrowArray.allocateNew((BufferAllocator)NativeScanner.this.context.getAllocator());){
                    if (!JniWrapper.get().nextRecordBatch(NativeScanner.this.scannerId, arrowArray.memoryAddress())) {
                        boolean bl = false;
                        return bl;
                    }
                    VectorSchemaRoot vsr = this.getVectorSchemaRoot();
                    Data.importIntoVectorSchemaRoot((BufferAllocator)NativeScanner.this.context.getAllocator(), (ArrowArray)arrowArray, (VectorSchemaRoot)vsr, (DictionaryProvider)this);
                }
            }
            finally {
                NativeScanner.this.readLock.unlock();
            }
            return true;
        }

        public long bytesRead() {
            return 0L;
        }

        protected void closeReadSource() throws IOException {
        }

        protected Schema readSchema() throws IOException {
            return NativeScanner.this.schema();
        }
    }
}

