/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.dataset.jni.ReservationListener;
import org.apache.arrow.util.VisibleForTesting;

public class DirectReservationListener
implements ReservationListener {
    private final Method methodReserve;
    private final Method methodUnreserve;
    private static final DirectReservationListener INSTANCE = new DirectReservationListener();

    private DirectReservationListener() {
        try {
            Class<?> classBits = Class.forName("java.nio.Bits");
            this.methodReserve = classBits.getDeclaredMethod("reserveMemory", Long.TYPE, Integer.TYPE);
            this.methodReserve.setAccessible(true);
            this.methodUnreserve = classBits.getDeclaredMethod("unreserveMemory", Long.TYPE, Integer.TYPE);
            this.methodUnreserve.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DirectReservationListener instance() {
        return INSTANCE;
    }

    @Override
    public void reserve(long size) {
        try {
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("reserve size should not be larger than Integer.MAX_VALUE (0x7fffffff)");
            }
            this.methodReserve.invoke(null, (int)size, (int)size);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unreserve(long size) {
        try {
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("unreserve size should not be larger than Integer.MAX_VALUE (0x7fffffff)");
            }
            this.methodUnreserve.invoke(null, (int)size, (int)size);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public long getCurrentDirectMemReservation() {
        try {
            Class<?> classBits = Class.forName("java.nio.Bits");
            Field f = classBits.getDeclaredField("reservedMemory");
            f.setAccessible(true);
            return ((AtomicLong)f.get(null)).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

