/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers.logical;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.avro.io.Encoder;

public class AvroTimestampSecTzProducer
extends BaseAvroProducer<TimeStampSecTZVector> {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long OVERFLOW_LIMIT = 9223372036854775L;

    public AvroTimestampSecTzProducer(TimeStampSecTZVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long utcSeconds = ((TimeStampSecTZVector)this.vector).getDataBuffer().getLong((long)this.currentIndex * 8L);
        if (Math.abs(utcSeconds) > 9223372036854775L) {
            throw new ArithmeticException("Timestamp value is too large for Avro encoding");
        }
        long utcMillis = utcSeconds * 1000L;
        encoder.writeLong(utcMillis);
        ++this.currentIndex;
    }
}

