/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers.logical;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.avro.io.Encoder;

public class AvroTimeSecProducer
extends BaseAvroProducer<TimeSecVector> {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final long OVERFLOW_LIMIT = 2147483L;

    public AvroTimeSecProducer(TimeSecVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        int seconds = ((TimeSecVector)this.vector).getDataBuffer().getInt((long)this.currentIndex * 4L);
        if ((long)Math.abs(seconds) > 2147483L) {
            throw new ArithmeticException("Time value is too large for Avro encoding");
        }
        int millis = seconds * 1000;
        encoder.writeInt(millis);
        ++this.currentIndex;
    }
}

