/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers.logical;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.avro.io.Encoder;

public class AvroTimeNanoProducer
extends BaseAvroProducer<TimeNanoVector> {
    private static final long NANOS_PER_MICRO = 1000L;

    public AvroTimeNanoProducer(TimeNanoVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long nanos = ((TimeNanoVector)this.vector).getDataBuffer().getLong((long)this.currentIndex * 8L);
        long micros = nanos / 1000L;
        encoder.writeLong(micros);
        ++this.currentIndex;
    }
}

