/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.avro.io.Encoder;

public class AvroStructProducer
extends BaseAvroProducer<StructVector> {
    private final Producer<? extends FieldVector>[] delegates;

    public AvroStructProducer(StructVector vector, Producer<? extends FieldVector>[] delegates) {
        super(vector);
        this.delegates = delegates;
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        for (Producer<? extends FieldVector> delegate : this.delegates) {
            delegate.produce(encoder);
        }
        ++this.currentIndex;
    }

    @Override
    public void skipNull() {
        for (Producer<? extends FieldVector> delegate : this.delegates) {
            delegate.skipNull();
        }
        super.skipNull();
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index > ((StructVector)this.vector).getValueCount()) {
            throw new IllegalArgumentException("Index out of bounds: " + index);
        }
        for (Producer<? extends FieldVector> delegate : this.delegates) {
            delegate.setPosition(index);
        }
        super.setPosition(index);
    }

    @Override
    public void resetValueVector(StructVector vector) {
        for (int i = 0; i < this.delegates.length; ++i) {
            Producer<? extends FieldVector> delegate = this.delegates[i];
            delegate.resetValueVector((FieldVector)((FieldVector)vector.getChildrenFromFields().get(i)));
        }
    }
}

