/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.VarCharVector;
import org.apache.avro.io.Encoder;

public class AvroStringProducer
extends BaseAvroProducer<VarCharVector> {
    public AvroStringProducer(VarCharVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        int start = ((VarCharVector)this.vector).getStartOffset(this.currentIndex);
        int end = ((VarCharVector)this.vector).getEndOffset(this.currentIndex);
        int length = end - start;
        ByteBuffer nioBuffer = ((VarCharVector)this.vector).getDataBuffer().nioBuffer((long)start, length);
        encoder.writeBytes(nioBuffer);
        ++this.currentIndex;
    }
}

