/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.avro.io.Encoder;

public class AvroListProducer
extends BaseAvroProducer<ListVector> {
    private final Producer<? extends FieldVector> delegate;

    public AvroListProducer(ListVector vector, Producer<? extends FieldVector> delegate) {
        super(vector);
        this.delegate = delegate;
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        int startOffset = ((ListVector)this.vector).getOffsetBuffer().getInt((long)this.currentIndex * 4L);
        int endOffset = ((ListVector)this.vector).getOffsetBuffer().getInt((long)(this.currentIndex + 1) * 4L);
        int nItems = endOffset - startOffset;
        encoder.writeArrayStart();
        encoder.setItemCount((long)nItems);
        for (int i = 0; i < nItems; ++i) {
            encoder.startItem();
            this.delegate.produce(encoder);
        }
        encoder.writeArrayEnd();
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index > ((ListVector)this.vector).getValueCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        int delegateOffset = ((ListVector)this.vector).getOffsetBuffer().getInt((long)index * 4L);
        this.delegate.setPosition(delegateOffset);
        super.setPosition(index);
    }

    @Override
    public void resetValueVector(ListVector vector) {
        this.delegate.resetValueVector((FieldVector)vector.getDataVector());
    }
}

