/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.avro.io.Encoder;

public class AvroBigIntProducer
extends BaseAvroProducer<BaseFixedWidthVector> {
    public AvroBigIntProducer(BigIntVector vector) {
        super(vector);
    }

    protected AvroBigIntProducer(BaseFixedWidthVector vector) {
        super(vector);
        if (vector.getTypeWidth() != 8) {
            throw new IllegalArgumentException("AvroBigIntProducer requires type width = 8");
        }
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long value = ((BaseFixedWidthVector)this.vector).getDataBuffer().getLong((long)this.currentIndex * 8L);
        encoder.writeLong(value);
        ++this.currentIndex;
    }
}

