/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow;

import java.io.IOException;
import org.apache.arrow.AvroToArrowConfig;
import org.apache.arrow.AvroToArrowUtils;
import org.apache.arrow.AvroToArrowVectorIterator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public class AvroToArrow {
    static VectorSchemaRoot avroToArrow(Schema schema, Decoder decoder, AvroToArrowConfig config) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Avro schema object cannot be null");
        Preconditions.checkNotNull((Object)decoder, (Object)"Avro decoder object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        return AvroToArrowUtils.avroToArrowVectors(schema, decoder, config);
    }

    public static AvroToArrowVectorIterator avroToArrowIterator(Schema schema, Decoder decoder, AvroToArrowConfig config) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Avro schema object cannot be null");
        Preconditions.checkNotNull((Object)decoder, (Object)"Avro decoder object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        return AvroToArrowVectorIterator.create(decoder, schema, config);
    }
}

