/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.AvroToArrowConfig;
import org.apache.arrow.consumers.AvroArraysConsumer;
import org.apache.arrow.consumers.AvroBooleanConsumer;
import org.apache.arrow.consumers.AvroBytesConsumer;
import org.apache.arrow.consumers.AvroDoubleConsumer;
import org.apache.arrow.consumers.AvroEnumConsumer;
import org.apache.arrow.consumers.AvroFixedConsumer;
import org.apache.arrow.consumers.AvroFloatConsumer;
import org.apache.arrow.consumers.AvroIntConsumer;
import org.apache.arrow.consumers.AvroLongConsumer;
import org.apache.arrow.consumers.AvroMapConsumer;
import org.apache.arrow.consumers.AvroNullConsumer;
import org.apache.arrow.consumers.AvroStringConsumer;
import org.apache.arrow.consumers.AvroStructConsumer;
import org.apache.arrow.consumers.AvroUnionsConsumer;
import org.apache.arrow.consumers.CompositeAvroConsumer;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.consumers.SkipConsumer;
import org.apache.arrow.consumers.SkipFunction;
import org.apache.arrow.consumers.logical.AvroDateConsumer;
import org.apache.arrow.consumers.logical.AvroDecimalConsumer;
import org.apache.arrow.consumers.logical.AvroTimeMicroConsumer;
import org.apache.arrow.consumers.logical.AvroTimeMillisConsumer;
import org.apache.arrow.consumers.logical.AvroTimestampMicrosConsumer;
import org.apache.arrow.consumers.logical.AvroTimestampMillisConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.ValueVectorUtility;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public class AvroToArrowUtils {
    private static Consumer createConsumer(Schema schema, String name, AvroToArrowConfig config) {
        return AvroToArrowUtils.createConsumer(schema, name, false, config, null);
    }

    private static Consumer createConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector vector) {
        return AvroToArrowUtils.createConsumer(schema, name, false, config, vector);
    }

    private static Consumer createConsumer(Schema schema, String name, boolean nullable, AvroToArrowConfig config, FieldVector consumerVector) {
        Consumer consumer;
        Preconditions.checkNotNull((Object)schema, (Object)"Avro schema object can't be null");
        Preconditions.checkNotNull((Object)config, (Object)"Config can't be null");
        BufferAllocator allocator = config.getAllocator();
        Schema.Type type = schema.getType();
        LogicalType logicalType = schema.getLogicalType();
        switch (type) {
            case UNION: {
                consumer = AvroToArrowUtils.createUnionConsumer(schema, name, config, consumerVector);
                break;
            }
            case ARRAY: {
                consumer = AvroToArrowUtils.createArrayConsumer(schema, name, config, consumerVector);
                break;
            }
            case MAP: {
                consumer = AvroToArrowUtils.createMapConsumer(schema, name, config, consumerVector);
                break;
            }
            case RECORD: {
                consumer = AvroToArrowUtils.createStructConsumer(schema, name, config, consumerVector);
                break;
            }
            case ENUM: {
                consumer = AvroToArrowUtils.createEnumConsumer(schema, name, config, consumerVector);
                break;
            }
            case STRING: {
                ArrowType.Utf8 arrowType = new ArrowType.Utf8();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroStringConsumer((VarCharVector)vector);
                break;
            }
            case FIXED: {
                Map<String, String> extProps = AvroToArrowUtils.createExternalProps(schema);
                if (logicalType instanceof LogicalTypes.Decimal) {
                    ArrowType arrowType = AvroToArrowUtils.createDecimalArrowType((LogicalTypes.Decimal)logicalType);
                    FieldType fieldType = new FieldType(nullable, arrowType, null, AvroToArrowUtils.getMetaData(schema, extProps));
                    FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                    consumer = new AvroDecimalConsumer.FixedDecimalConsumer((DecimalVector)vector, schema.getFixedSize());
                    break;
                }
                ArrowType.FixedSizeBinary arrowType = new ArrowType.FixedSizeBinary(schema.getFixedSize());
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema, extProps));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroFixedConsumer((FixedSizeBinaryVector)vector, schema.getFixedSize());
                break;
            }
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    ArrowType.Date arrowType = new ArrowType.Date(DateUnit.DAY);
                    FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                    FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                    consumer = new AvroDateConsumer((DateDayVector)vector);
                    break;
                }
                if (logicalType instanceof LogicalTypes.TimeMillis) {
                    ArrowType.Time arrowType = new ArrowType.Time(TimeUnit.MILLISECOND, 32);
                    FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                    FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                    consumer = new AvroTimeMillisConsumer((TimeMilliVector)vector);
                    break;
                }
                ArrowType.Int arrowType = new ArrowType.Int(32, true);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroIntConsumer((IntVector)vector);
                break;
            }
            case BOOLEAN: {
                ArrowType.Bool arrowType = new ArrowType.Bool();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroBooleanConsumer((BitVector)vector);
                break;
            }
            case LONG: {
                if (logicalType instanceof LogicalTypes.TimeMicros) {
                    ArrowType.Time arrowType = new ArrowType.Time(TimeUnit.MICROSECOND, 64);
                    FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                    FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                    consumer = new AvroTimeMicroConsumer((TimeMicroVector)vector);
                    break;
                }
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    ArrowType.Timestamp arrowType = new ArrowType.Timestamp(TimeUnit.MILLISECOND, null);
                    FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                    FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                    consumer = new AvroTimestampMillisConsumer((TimeStampMilliVector)vector);
                    break;
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    ArrowType.Timestamp arrowType = new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
                    FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                    FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                    consumer = new AvroTimestampMicrosConsumer((TimeStampMicroVector)vector);
                    break;
                }
                ArrowType.Int arrowType = new ArrowType.Int(64, true);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroLongConsumer((BigIntVector)vector);
                break;
            }
            case FLOAT: {
                ArrowType.FloatingPoint arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroFloatConsumer((Float4Vector)vector);
                break;
            }
            case DOUBLE: {
                ArrowType.FloatingPoint arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroDoubleConsumer((Float8Vector)vector);
                break;
            }
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    ArrowType arrowType = AvroToArrowUtils.createDecimalArrowType((LogicalTypes.Decimal)logicalType);
                    FieldType fieldType = new FieldType(nullable, arrowType, null, AvroToArrowUtils.getMetaData(schema));
                    FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                    consumer = new AvroDecimalConsumer.BytesDecimalConsumer((DecimalVector)vector);
                    break;
                }
                ArrowType.Binary arrowType = new ArrowType.Binary();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroBytesConsumer((VarBinaryVector)vector);
                break;
            }
            case NULL: {
                ArrowType.Null arrowType = new ArrowType.Null();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = fieldType.createNewSingleVector(name, allocator, null);
                consumer = new AvroNullConsumer((NullVector)vector);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can't convert avro type %s to arrow type." + type.getName());
            }
        }
        return consumer;
    }

    private static ArrowType createDecimalArrowType(LogicalTypes.Decimal logicalType) {
        int scale = logicalType.getScale();
        int precision = logicalType.getPrecision();
        Preconditions.checkArgument((precision > 0 && precision <= 38 ? 1 : 0) != 0, (Object)"Precision must be in range of 1 to 38");
        Preconditions.checkArgument((scale >= 0 && scale <= 38 ? 1 : 0) != 0, (Object)"Scale must be in range of 0 to 38.");
        Preconditions.checkArgument((scale <= precision ? 1 : 0) != 0, (String)"Invalid decimal scale: %s (greater than precision: %s)", (int)scale, (int)precision);
        return new ArrowType.Decimal(precision, scale, 128);
    }

    private static Consumer createSkipConsumer(Schema schema) {
        SkipFunction skipFunction;
        Schema.Type type = schema.getType();
        switch (type) {
            case UNION: {
                List unionDelegates = schema.getTypes().stream().map(s -> AvroToArrowUtils.createSkipConsumer(s)).collect(Collectors.toList());
                skipFunction = decoder -> ((Consumer)unionDelegates.get(decoder.readInt())).consume(decoder);
                break;
            }
            case ARRAY: {
                Consumer elementDelegate = AvroToArrowUtils.createSkipConsumer(schema.getElementType());
                skipFunction = decoder -> {
                    long i = decoder.skipArray();
                    while (i != 0L) {
                        for (long j = 0L; j < i; ++j) {
                            elementDelegate.consume(decoder);
                        }
                        i = decoder.skipArray();
                    }
                };
                break;
            }
            case MAP: {
                Consumer valueDelegate = AvroToArrowUtils.createSkipConsumer(schema.getValueType());
                skipFunction = decoder -> {
                    long i = decoder.skipMap();
                    while (i != 0L) {
                        for (long j = 0L; j < i; ++j) {
                            decoder.skipString();
                            valueDelegate.consume(decoder);
                        }
                        i = decoder.skipMap();
                    }
                };
                break;
            }
            case RECORD: {
                List delegates = schema.getFields().stream().map(field -> AvroToArrowUtils.createSkipConsumer(field.schema())).collect(Collectors.toList());
                skipFunction = decoder -> {
                    for (Consumer consumer : delegates) {
                        consumer.consume(decoder);
                    }
                };
                break;
            }
            case ENUM: {
                skipFunction = decoder -> decoder.readEnum();
                break;
            }
            case STRING: {
                skipFunction = decoder -> decoder.skipString();
                break;
            }
            case FIXED: {
                skipFunction = decoder -> decoder.skipFixed(schema.getFixedSize());
                break;
            }
            case INT: {
                skipFunction = decoder -> decoder.readInt();
                break;
            }
            case BOOLEAN: {
                skipFunction = decoder -> decoder.skipFixed(1);
                break;
            }
            case LONG: {
                skipFunction = decoder -> decoder.readLong();
                break;
            }
            case FLOAT: {
                skipFunction = decoder -> decoder.readFloat();
                break;
            }
            case DOUBLE: {
                skipFunction = decoder -> decoder.readDouble();
                break;
            }
            case BYTES: {
                skipFunction = decoder -> decoder.skipBytes();
                break;
            }
            case NULL: {
                skipFunction = decoder -> {};
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid avro type: " + type.getName());
            }
        }
        return new SkipConsumer(skipFunction);
    }

    static CompositeAvroConsumer createCompositeConsumer(Schema schema, AvroToArrowConfig config) {
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        Set<String> skipFieldNames = config.getSkipFieldNames();
        Schema.Type type = schema.getType();
        if (type == Schema.Type.RECORD) {
            for (Schema.Field field : schema.getFields()) {
                if (skipFieldNames.contains(field.name())) {
                    consumers.add(AvroToArrowUtils.createSkipConsumer(field.schema()));
                    continue;
                }
                Consumer consumer = AvroToArrowUtils.createConsumer(field.schema(), field.name(), config);
                consumers.add(consumer);
            }
        } else {
            Consumer consumer = AvroToArrowUtils.createConsumer(schema, "", config);
            consumers.add(consumer);
        }
        return new CompositeAvroConsumer(consumers);
    }

    private static FieldVector createVector(FieldVector consumerVector, FieldType fieldType, String name, BufferAllocator allocator) {
        return consumerVector != null ? consumerVector : fieldType.createNewSingleVector(name, allocator, null);
    }

    private static String getDefaultFieldName(ArrowType type) {
        Types.MinorType minorType = Types.getMinorTypeForArrowType((ArrowType)type);
        return minorType.name().toLowerCase();
    }

    private static Field avroSchemaToField(Schema schema, String name, AvroToArrowConfig config) {
        return AvroToArrowUtils.avroSchemaToField(schema, name, config, null);
    }

    private static Field avroSchemaToField(Schema schema, String name, AvroToArrowConfig config, Map<String, String> externalProps) {
        FieldType fieldType;
        Schema.Type type = schema.getType();
        LogicalType logicalType = schema.getLogicalType();
        ArrayList<Field> children = new ArrayList<Field>();
        switch (type) {
            case UNION: {
                for (int i = 0; i < schema.getTypes().size(); ++i) {
                    Schema childSchema = (Schema)schema.getTypes().get(i);
                    children.add(AvroToArrowUtils.avroSchemaToField(childSchema, null, config));
                }
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.Union(UnionMode.Sparse, null), schema, externalProps);
                break;
            }
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                children.add(AvroToArrowUtils.avroSchemaToField(elementSchema, elementSchema.getName(), config));
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.List(), schema, externalProps);
                break;
            }
            case MAP: {
                FieldType keyFieldType = new FieldType(false, (ArrowType)new ArrowType.Utf8(), null);
                Field keyField = new Field("key", keyFieldType, null);
                Field valueField = AvroToArrowUtils.avroSchemaToField(schema.getValueType(), "value", config);
                FieldType structFieldType = new FieldType(false, (ArrowType)new ArrowType.Struct(), null);
                Field structField = new Field("internal", structFieldType, Arrays.asList(keyField, valueField));
                children.add(structField);
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.Map(false), schema, externalProps);
                break;
            }
            case RECORD: {
                Set<String> skipFieldNames = config.getSkipFieldNames();
                for (int i = 0; i < schema.getFields().size(); ++i) {
                    Schema.Field field = (Schema.Field)schema.getFields().get(i);
                    Schema childSchema = field.schema();
                    String fullChildName = String.format("%s.%s", name, field.name());
                    if (skipFieldNames.contains(fullChildName)) continue;
                    HashMap<String, String> extProps = new HashMap<String, String>();
                    String doc = field.doc();
                    Set aliases = field.aliases();
                    if (doc != null) {
                        extProps.put("doc", doc);
                    }
                    if (aliases != null) {
                        extProps.put("aliases", AvroToArrowUtils.convertAliases(aliases));
                    }
                    children.add(AvroToArrowUtils.avroSchemaToField(childSchema, fullChildName, config, extProps));
                }
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.Struct(), schema, externalProps);
                break;
            }
            case ENUM: {
                DictionaryProvider.MapDictionaryProvider provider = config.getProvider();
                int current = provider.getDictionaryIds().size();
                int enumCount = schema.getEnumSymbols().size();
                ArrowType.Int indexType = DictionaryEncoder.getIndexType((int)enumCount);
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)indexType, schema, externalProps, new DictionaryEncoding((long)current, false, indexType));
                break;
            }
            case STRING: {
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.Utf8(), schema, externalProps);
                break;
            }
            case FIXED: {
                Object fixedArrowType = logicalType instanceof LogicalTypes.Decimal ? AvroToArrowUtils.createDecimalArrowType((LogicalTypes.Decimal)logicalType) : new ArrowType.FixedSizeBinary(schema.getFixedSize());
                fieldType = AvroToArrowUtils.createFieldType(fixedArrowType, schema, externalProps);
                break;
            }
            case INT: {
                Object intArrowType = logicalType instanceof LogicalTypes.Date ? new ArrowType.Date(DateUnit.DAY) : (logicalType instanceof LogicalTypes.TimeMillis ? new ArrowType.Time(TimeUnit.MILLISECOND, 32) : new ArrowType.Int(32, true));
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)intArrowType, schema, externalProps);
                break;
            }
            case BOOLEAN: {
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.Bool(), schema, externalProps);
                break;
            }
            case LONG: {
                Object longArrowType = logicalType instanceof LogicalTypes.TimeMicros ? new ArrowType.Time(TimeUnit.MICROSECOND, 64) : (logicalType instanceof LogicalTypes.TimestampMillis ? new ArrowType.Timestamp(TimeUnit.MILLISECOND, null) : (logicalType instanceof LogicalTypes.TimestampMicros ? new ArrowType.Timestamp(TimeUnit.MICROSECOND, null) : new ArrowType.Int(64, true)));
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)longArrowType, schema, externalProps);
                break;
            }
            case FLOAT: {
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), schema, externalProps);
                break;
            }
            case DOUBLE: {
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), schema, externalProps);
                break;
            }
            case BYTES: {
                Object bytesArrowType = logicalType instanceof LogicalTypes.Decimal ? AvroToArrowUtils.createDecimalArrowType((LogicalTypes.Decimal)logicalType) : new ArrowType.Binary();
                fieldType = AvroToArrowUtils.createFieldType(bytesArrowType, schema, externalProps);
                break;
            }
            case NULL: {
                fieldType = AvroToArrowUtils.createFieldType((ArrowType)ArrowType.Null.INSTANCE, schema, externalProps);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (name == null) {
            name = AvroToArrowUtils.getDefaultFieldName(fieldType.getType());
        }
        return new Field(name, fieldType, children.size() == 0 ? null : children);
    }

    private static Consumer createArrayConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        ListVector listVector;
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            listVector = (ListVector)field.createVector(config.getAllocator());
        } else {
            listVector = (ListVector)consumerVector;
        }
        FieldVector dataVector = listVector.getDataVector();
        Schema childSchema = schema.getElementType();
        Consumer delegate = AvroToArrowUtils.createConsumer(childSchema, childSchema.getName(), config, dataVector);
        return new AvroArraysConsumer(listVector, delegate);
    }

    private static Consumer createStructConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        StructVector structVector;
        Set<String> skipFieldNames = config.getSkipFieldNames();
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config, AvroToArrowUtils.createExternalProps(schema));
            structVector = (StructVector)field.createVector(config.getAllocator());
        } else {
            structVector = (StructVector)consumerVector;
        }
        Consumer[] delegates = new Consumer[schema.getFields().size()];
        int vectorIndex = 0;
        for (int i = 0; i < schema.getFields().size(); ++i) {
            Schema.Field childField = (Schema.Field)schema.getFields().get(i);
            String fullChildName = String.format("%s.%s", name, childField.name());
            Consumer delegate = skipFieldNames.contains(fullChildName) ? AvroToArrowUtils.createSkipConsumer(childField.schema()) : AvroToArrowUtils.createConsumer(childField.schema(), fullChildName, config, (FieldVector)structVector.getChildrenFromFields().get(vectorIndex++));
            delegates[i] = delegate;
        }
        return new AvroStructConsumer(structVector, delegates);
    }

    private static Consumer createEnumConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        BaseIntVector indexVector;
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config, AvroToArrowUtils.createExternalProps(schema));
            indexVector = (BaseIntVector)field.createVector(config.getAllocator());
        } else {
            indexVector = (BaseIntVector)consumerVector;
        }
        int valueCount = schema.getEnumSymbols().size();
        VarCharVector dictVector = new VarCharVector(name, config.getAllocator());
        dictVector.allocateNewSafe();
        dictVector.setValueCount(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            dictVector.set(i, ((String)schema.getEnumSymbols().get(i)).getBytes(StandardCharsets.UTF_8));
        }
        Dictionary dictionary = new Dictionary((FieldVector)dictVector, indexVector.getField().getDictionary());
        config.getProvider().put(dictionary);
        return new AvroEnumConsumer(indexVector);
    }

    private static Consumer createMapConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        MapVector mapVector;
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            mapVector = (MapVector)field.createVector(config.getAllocator());
        } else {
            mapVector = (MapVector)consumerVector;
        }
        StructVector structVector = (StructVector)mapVector.getDataVector();
        AvroStringConsumer keyConsumer = new AvroStringConsumer((VarCharVector)structVector.getChildrenFromFields().get(0));
        Consumer valueConsumer = AvroToArrowUtils.createConsumer(schema.getValueType(), schema.getValueType().getName(), config, (FieldVector)structVector.getChildrenFromFields().get(1));
        AvroStructConsumer internalConsumer = new AvroStructConsumer(structVector, new Consumer[]{keyConsumer, valueConsumer});
        return new AvroMapConsumer(mapVector, internalConsumer);
    }

    private static Consumer createUnionConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        UnionVector unionVector;
        int size = schema.getTypes().size();
        boolean nullable = schema.getTypes().stream().anyMatch(t -> t.getType() == Schema.Type.NULL);
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            unionVector = (UnionVector)field.createVector(config.getAllocator());
        } else {
            unionVector = (UnionVector)consumerVector;
        }
        List childVectors = unionVector.getChildrenFromFields();
        Consumer[] delegates = new Consumer[size];
        Types.MinorType[] types = new Types.MinorType[size];
        for (int i = 0; i < size; ++i) {
            Consumer delegate;
            FieldVector child = (FieldVector)childVectors.get(i);
            Schema subSchema = (Schema)schema.getTypes().get(i);
            delegates[i] = delegate = AvroToArrowUtils.createConsumer(subSchema, subSchema.getName(), nullable, config, child);
            types[i] = child.getMinorType();
        }
        return new AvroUnionsConsumer(unionVector, delegates, types);
    }

    static VectorSchemaRoot avroToArrowVectors(Schema schema, Decoder decoder, AvroToArrowConfig config) throws IOException {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        Set<String> skipFieldNames = config.getSkipFieldNames();
        Schema.Type type = schema.getType();
        if (type == Schema.Type.RECORD) {
            for (Schema.Field field : schema.getFields()) {
                if (skipFieldNames.contains(field.name())) {
                    consumers.add(AvroToArrowUtils.createSkipConsumer(field.schema()));
                    continue;
                }
                Consumer consumer = AvroToArrowUtils.createConsumer(field.schema(), field.name(), config);
                consumers.add(consumer);
                vectors.add(consumer.getVector());
            }
        } else {
            Consumer consumer = AvroToArrowUtils.createConsumer(schema, "", config);
            consumers.add(consumer);
            vectors.add(consumer.getVector());
        }
        long validConsumerCount = consumers.stream().filter(c -> !c.skippable()).count();
        Preconditions.checkArgument(((long)vectors.size() == validConsumerCount ? 1 : 0) != 0, (Object)"vectors size not equals consumers size.");
        List fields = vectors.stream().map(t -> t.getField()).collect(Collectors.toList());
        VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, 0);
        CompositeAvroConsumer compositeConsumer = new CompositeAvroConsumer(consumers);
        int valueCount = 0;
        try {
            while (true) {
                ValueVectorUtility.ensureCapacity((VectorSchemaRoot)root, (int)(valueCount + 1));
                compositeConsumer.consume(decoder);
                ++valueCount;
            }
        }
        catch (EOFException eof) {
            root.setRowCount(valueCount);
        }
        catch (Exception e) {
            compositeConsumer.close();
            throw new UnsupportedOperationException("Error occurs while consume process.", e);
        }
        return root;
    }

    private static Map<String, String> getMetaData(Schema schema) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        schema.getObjectProps().forEach((k, v) -> metadata.put((String)k, v.toString()));
        return metadata;
    }

    private static Map<String, String> getMetaData(Schema schema, Map<String, String> externalProps) {
        Map<String, String> metadata = AvroToArrowUtils.getMetaData(schema);
        if (externalProps != null) {
            metadata.putAll(externalProps);
        }
        return metadata;
    }

    private static Map<String, String> createExternalProps(Schema schema) {
        HashMap<String, String> extProps = new HashMap<String, String>();
        String doc = schema.getDoc();
        Set aliases = schema.getAliases();
        if (doc != null) {
            extProps.put("doc", doc);
        }
        if (aliases != null) {
            extProps.put("aliases", AvroToArrowUtils.convertAliases(aliases));
        }
        return extProps;
    }

    private static FieldType createFieldType(ArrowType arrowType, Schema schema, Map<String, String> externalProps) {
        return AvroToArrowUtils.createFieldType(arrowType, schema, externalProps, null);
    }

    private static FieldType createFieldType(ArrowType arrowType, Schema schema, Map<String, String> externalProps, DictionaryEncoding dictionary) {
        return new FieldType(false, arrowType, dictionary, AvroToArrowUtils.getMetaData(schema, externalProps));
    }

    private static String convertAliases(Set<String> aliases) {
        JsonStringArrayList jsonList = new JsonStringArrayList();
        aliases.stream().forEach(a -> jsonList.add(a));
        return jsonList.toString();
    }
}

