/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers.logical;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.arrow.consumers.BaseAvroConsumer;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.DecimalVector;
import org.apache.avro.io.Decoder;

public abstract class AvroDecimalConsumer
extends BaseAvroConsumer<DecimalVector> {
    public AvroDecimalConsumer(DecimalVector vector) {
        super(vector);
    }

    public static class FixedDecimalConsumer
    extends AvroDecimalConsumer {
        private byte[] reuseBytes;

        public FixedDecimalConsumer(DecimalVector vector, int size) {
            super(vector);
            Preconditions.checkArgument((size <= 16 ? 1 : 0) != 0, (Object)"Decimal bytes length should <= 16.");
            this.reuseBytes = new byte[size];
        }

        @Override
        public void consume(Decoder decoder) throws IOException {
            decoder.readFixed(this.reuseBytes);
            ((DecimalVector)this.vector).setBigEndianSafe(this.currentIndex++, this.reuseBytes);
        }
    }

    public static class BytesDecimalConsumer
    extends AvroDecimalConsumer {
        private ByteBuffer cacheBuffer;

        public BytesDecimalConsumer(DecimalVector vector) {
            super(vector);
        }

        @Override
        public void consume(Decoder decoder) throws IOException {
            this.cacheBuffer = decoder.readBytes(this.cacheBuffer);
            byte[] bytes = new byte[this.cacheBuffer.limit()];
            Preconditions.checkArgument((bytes.length <= 16 ? 1 : 0) != 0, (Object)"Decimal bytes length should <= 16.");
            this.cacheBuffer.get(bytes);
            ((DecimalVector)this.vector).setBigEndianSafe(this.currentIndex++, bytes);
        }
    }
}

