/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.BaseAvroConsumer;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.types.Types;
import org.apache.avro.io.Decoder;

public class AvroUnionsConsumer
extends BaseAvroConsumer<UnionVector> {
    private Consumer[] delegates;
    private Types.MinorType[] types;

    public AvroUnionsConsumer(UnionVector vector, Consumer[] delegates, Types.MinorType[] types) {
        super(vector);
        this.delegates = delegates;
        this.types = types;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        int fieldIndex = decoder.readInt();
        Consumer delegate = this.delegates[fieldIndex];
        ((UnionVector)this.vector).setType(this.currentIndex, this.types[fieldIndex]);
        delegate.setPosition(this.currentIndex);
        delegate.consume(decoder);
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        super.close();
        AutoCloseables.close((AutoCloseable[])this.delegates);
    }

    @Override
    public boolean resetValueVector(UnionVector vector) {
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].resetValueVector((FieldVector)vector.getChildrenFromFields().get(i));
        }
        return super.resetValueVector(vector);
    }
}

