/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.AvroToArrowConfig;
import org.apache.arrow.AvroToArrowUtils;
import org.apache.arrow.consumers.CompositeAvroConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.avro.io.Decoder;

public class AvroToArrowVectorIterator
implements Iterator<VectorSchemaRoot>,
AutoCloseable {
    public static final int NO_LIMIT_BATCH_SIZE = -1;
    public static final int DEFAULT_BATCH_SIZE = 1024;
    private final Decoder decoder;
    private final org.apache.avro.Schema schema;
    private final AvroToArrowConfig config;
    private CompositeAvroConsumer compositeConsumer;
    private Schema rootSchema;
    private VectorSchemaRoot nextBatch;
    private final int targetBatchSize;

    private AvroToArrowVectorIterator(Decoder decoder, org.apache.avro.Schema schema, AvroToArrowConfig config) {
        this.decoder = decoder;
        this.schema = schema;
        this.config = config;
        this.targetBatchSize = config.getTargetBatchSize();
    }

    public static AvroToArrowVectorIterator create(Decoder decoder, org.apache.avro.Schema schema, AvroToArrowConfig config) {
        AvroToArrowVectorIterator iterator = new AvroToArrowVectorIterator(decoder, schema, config);
        try {
            iterator.initialize();
            return iterator;
        }
        catch (Exception e) {
            iterator.close();
            throw new RuntimeException("Error occurs while creating iterator.", e);
        }
    }

    private void initialize() {
        this.compositeConsumer = AvroToArrowUtils.createCompositeConsumer(this.schema, this.config);
        ArrayList vectors = new ArrayList();
        this.compositeConsumer.getConsumers().forEach(c -> vectors.add(c.getVector()));
        List fields = vectors.stream().map(t -> t.getField()).collect(Collectors.toList());
        VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, 0);
        this.rootSchema = root.getSchema();
        this.load(root);
    }

    private void consumeData(VectorSchemaRoot root) {
        int readRowCount;
        try {
            for (readRowCount = 0; this.targetBatchSize == -1 || readRowCount < this.targetBatchSize; ++readRowCount) {
                this.compositeConsumer.consume(this.decoder);
            }
            root.setRowCount(readRowCount);
        }
        catch (EOFException eof) {
            root.setRowCount(readRowCount);
        }
        catch (Exception e) {
            this.compositeConsumer.close();
            throw new RuntimeException("Error occurs while consuming data.", e);
        }
    }

    private void load(VectorSchemaRoot root) {
        long validConsumerCount = this.compositeConsumer.getConsumers().stream().filter(c -> !c.skippable()).count();
        Preconditions.checkArgument(((long)root.getFieldVectors().size() == validConsumerCount ? 1 : 0) != 0, (Object)"Schema root vectors size not equals to consumers size.");
        this.compositeConsumer.resetConsumerVectors(root);
        this.consumeData(root);
        if (root.getRowCount() == 0) {
            root.close();
            this.nextBatch = null;
        } else {
            this.nextBatch = root;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextBatch != null;
    }

    @Override
    public VectorSchemaRoot next() {
        Preconditions.checkArgument((boolean)this.hasNext());
        VectorSchemaRoot returned = this.nextBatch;
        try {
            this.load(VectorSchemaRoot.create((Schema)this.rootSchema, (BufferAllocator)this.config.getAllocator()));
        }
        catch (Exception e) {
            returned.close();
            throw new RuntimeException("Error occurs while getting next schema root.", e);
        }
        return returned;
    }

    @Override
    public void close() {
        if (this.nextBatch != null) {
            this.nextBatch.close();
        }
        this.compositeConsumer.close();
    }
}

