/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.avro.io.Decoder;

public class NullableTypeConsumer
implements Consumer {
    private final Consumer delegate;
    protected int nullIndex;

    public NullableTypeConsumer(Consumer delegate, int nullIndex) {
        this.delegate = delegate;
        this.nullIndex = nullIndex;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        if (this.nullIndex != decoder.readInt()) {
            this.delegate.consume(decoder);
        } else {
            this.addNull();
        }
    }

    @Override
    public void addNull() {
        this.delegate.addNull();
    }

    @Override
    public void setPosition(int index) {
        this.delegate.setPosition(index);
    }

    @Override
    public FieldVector getVector() {
        return this.delegate.getVector();
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    public void resetValueVector(ValueVector vector) {
        this.delegate.resetValueVector(vector);
    }
}

