/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.types.Types;
import org.apache.avro.io.Decoder;

public class AvroUnionsConsumer
implements Consumer<UnionVector> {
    private Consumer[] delegates;
    private Types.MinorType[] types;
    private UnionVector vector;
    private int currentIndex;

    public AvroUnionsConsumer(UnionVector vector, Consumer[] delegates, Types.MinorType[] types) {
        this.vector = vector;
        this.delegates = delegates;
        this.types = types;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        int fieldIndex = decoder.readInt();
        Consumer delegate = this.delegates[fieldIndex];
        this.vector.setType(this.currentIndex, this.types[fieldIndex]);
        delegate.setPosition(this.currentIndex);
        delegate.consume(decoder);
        ++this.currentIndex;
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        this.vector.setValueCount(this.currentIndex);
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
        AutoCloseables.close((AutoCloseable[])this.delegates);
    }

    @Override
    public void resetValueVector(UnionVector vector) {
        this.vector = vector;
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].resetValueVector((ValueVector)vector.getChildrenFromFields().get(i));
        }
        this.currentIndex = 0;
    }
}

