/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.avro.io.Decoder;

public class AvroStringConsumer
implements Consumer<VarCharVector> {
    private VarCharVector vector;
    private ByteBuffer cacheBuffer;
    private int currentIndex;

    public AvroStringConsumer(VarCharVector vector) {
        this.vector = vector;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.cacheBuffer = decoder.readBytes(this.cacheBuffer);
        this.vector.setSafe(this.currentIndex++, this.cacheBuffer, 0, this.cacheBuffer.limit());
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(VarCharVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

