/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.avro.io.Decoder;

public class AvroFixedConsumer
implements Consumer<FixedSizeBinaryVector> {
    private FixedSizeBinaryVector vector;
    private final byte[] reuseBytes;
    private int currentIndex;

    public AvroFixedConsumer(FixedSizeBinaryVector vector, int size) {
        this.vector = vector;
        this.reuseBytes = new byte[size];
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        decoder.readFixed(this.reuseBytes);
        this.vector.setSafe(this.currentIndex++, this.reuseBytes);
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(FixedSizeBinaryVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

