/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.avro.io.Decoder;

public class AvroArraysConsumer
implements Consumer<ListVector> {
    private ListVector vector;
    private final Consumer delegate;
    private int currentIndex = 0;

    public AvroArraysConsumer(ListVector vector, Consumer delegate) {
        this.vector = vector;
        this.delegate = delegate;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.vector.startNewValue(this.currentIndex);
        long totalCount = 0L;
        long count = decoder.readArrayStart();
        while (count != 0L) {
            totalCount += count;
            int element = 0;
            while ((long)element < count) {
                this.delegate.consume(decoder);
                ++element;
            }
            count = decoder.arrayNext();
        }
        this.vector.endValue(this.currentIndex, (int)totalCount);
        ++this.currentIndex;
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
        this.delegate.close();
    }

    @Override
    public void resetValueVector(ListVector vector) {
        this.currentIndex = 0;
        this.vector = vector;
        this.delegate.resetValueVector(vector.getDataVector());
    }
}

