/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.arrow.AvroToArrowConfig;
import org.apache.arrow.consumers.AvroArraysConsumer;
import org.apache.arrow.consumers.AvroBooleanConsumer;
import org.apache.arrow.consumers.AvroBytesConsumer;
import org.apache.arrow.consumers.AvroDoubleConsumer;
import org.apache.arrow.consumers.AvroEnumConsumer;
import org.apache.arrow.consumers.AvroFixedConsumer;
import org.apache.arrow.consumers.AvroFloatConsumer;
import org.apache.arrow.consumers.AvroIntConsumer;
import org.apache.arrow.consumers.AvroLongConsumer;
import org.apache.arrow.consumers.AvroMapConsumer;
import org.apache.arrow.consumers.AvroNullConsumer;
import org.apache.arrow.consumers.AvroStringConsumer;
import org.apache.arrow.consumers.AvroStructConsumer;
import org.apache.arrow.consumers.AvroUnionsConsumer;
import org.apache.arrow.consumers.CompositeAvroConsumer;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.consumers.NullableTypeConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ZeroVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;

public class AvroToArrowUtils {
    private static final int INVALID_NULL_INDEX = -1;

    private static Consumer createConsumer(Schema schema, String name, AvroToArrowConfig config) {
        return AvroToArrowUtils.createConsumer(schema, name, false, -1, config, null);
    }

    private static Consumer createConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector vector) {
        return AvroToArrowUtils.createConsumer(schema, name, false, -1, config, vector);
    }

    private static Consumer createConsumer(Schema schema, String name, boolean nullable, int nullIndex, AvroToArrowConfig config, FieldVector consumerVector) {
        Consumer consumer;
        Preconditions.checkNotNull((Object)schema, (Object)"Avro schema object can't be null");
        Preconditions.checkNotNull((Object)config, (Object)"Config can't be null");
        BufferAllocator allocator = config.getAllocator();
        Schema.Type type = schema.getType();
        switch (type) {
            case UNION: {
                consumer = AvroToArrowUtils.createUnionConsumer(schema, name, config, consumerVector);
                break;
            }
            case ARRAY: {
                consumer = AvroToArrowUtils.createArrayConsumer(schema, name, config, consumerVector);
                break;
            }
            case MAP: {
                consumer = AvroToArrowUtils.createMapConsumer(schema, name, config, consumerVector);
                break;
            }
            case RECORD: {
                consumer = AvroToArrowUtils.createStructConsumer(schema, name, config, consumerVector);
                break;
            }
            case ENUM: {
                consumer = AvroToArrowUtils.createEnumConsumer(schema, name, config, consumerVector);
                break;
            }
            case STRING: {
                ArrowType.Utf8 arrowType = new ArrowType.Utf8();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroStringConsumer((VarCharVector)vector);
                break;
            }
            case FIXED: {
                ArrowType.FixedSizeBinary arrowType = new ArrowType.FixedSizeBinary(schema.getFixedSize());
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroFixedConsumer((FixedSizeBinaryVector)vector, schema.getFixedSize());
                break;
            }
            case INT: {
                ArrowType.Int arrowType = new ArrowType.Int(32, true);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroIntConsumer((IntVector)vector);
                break;
            }
            case BOOLEAN: {
                ArrowType.Bool arrowType = new ArrowType.Bool();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroBooleanConsumer((BitVector)vector);
                break;
            }
            case LONG: {
                ArrowType.Int arrowType = new ArrowType.Int(64, true);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroLongConsumer((BigIntVector)vector);
                break;
            }
            case FLOAT: {
                ArrowType.FloatingPoint arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroFloatConsumer((Float4Vector)vector);
                break;
            }
            case DOUBLE: {
                ArrowType.FloatingPoint arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroDoubleConsumer((Float8Vector)vector);
                break;
            }
            case BYTES: {
                ArrowType.Binary arrowType = new ArrowType.Binary();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroBytesConsumer((VarBinaryVector)vector);
                break;
            }
            case NULL: {
                ArrowType.Null arrowType = new ArrowType.Null();
                FieldType fieldType = new FieldType(nullable, (ArrowType)arrowType, null, AvroToArrowUtils.getMetaData(schema));
                FieldVector vector = AvroToArrowUtils.createVector(consumerVector, fieldType, name, allocator);
                consumer = new AvroNullConsumer((ZeroVector)vector);
                break;
            }
            default: {
                throw new RuntimeException("Can't convert avro type %s to arrow type." + type.getName());
            }
        }
        if (nullable) {
            return new NullableTypeConsumer(consumer, nullIndex);
        }
        return consumer;
    }

    static CompositeAvroConsumer createCompositeConsumer(Schema schema, AvroToArrowConfig config) {
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        Schema.Type type = schema.getType();
        if (type == Schema.Type.RECORD) {
            for (Schema.Field field : schema.getFields()) {
                Consumer consumer = AvroToArrowUtils.createConsumer(field.schema(), field.name(), config);
                consumers.add(consumer);
            }
        } else {
            if (type == Schema.Type.ENUM) {
                throw new UnsupportedOperationException();
            }
            Consumer consumer = AvroToArrowUtils.createConsumer(schema, "", config);
            consumers.add(consumer);
        }
        return new CompositeAvroConsumer(consumers);
    }

    private static FieldVector createVector(FieldVector consumerVector, FieldType fieldType, String name, BufferAllocator allocator) {
        return consumerVector != null ? consumerVector : fieldType.createNewSingleVector(name, allocator, null);
    }

    private static String getDefaultFieldName(ArrowType type) {
        Types.MinorType minorType = Types.getMinorTypeForArrowType((ArrowType)type);
        return minorType.name().toLowerCase();
    }

    private static Field avroSchemaToField(Schema schema, String name, AvroToArrowConfig config) {
        ArrowType.Utf8 arrowType;
        Schema.Type type = schema.getType();
        switch (type) {
            case UNION: {
                ArrayList<Field> children = new ArrayList<Field>();
                for (int i = 0; i < schema.getTypes().size(); ++i) {
                    Schema childSchema = (Schema)schema.getTypes().get(i);
                    children.add(AvroToArrowUtils.avroSchemaToField(childSchema, null, config));
                }
                ArrowType.Union arrowType2 = new ArrowType.Union(UnionMode.Sparse, null);
                if (name == null) {
                    name = AvroToArrowUtils.getDefaultFieldName((ArrowType)arrowType2);
                }
                return new Field(name, FieldType.nullable((ArrowType)arrowType2), children);
            }
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                ArrowType.List arrowType3 = new ArrowType.List();
                if (name == null) {
                    name = AvroToArrowUtils.getDefaultFieldName((ArrowType)arrowType3);
                }
                return new Field(name, FieldType.nullable((ArrowType)arrowType3), Collections.singletonList(AvroToArrowUtils.avroSchemaToField(elementSchema, elementSchema.getName(), config)));
            }
            case MAP: {
                FieldType keyFieldType = new FieldType(false, (ArrowType)new ArrowType.Utf8(), null);
                Field keyField = new Field("key", keyFieldType, null);
                Field valueField = AvroToArrowUtils.avroSchemaToField(schema.getValueType(), "value", config);
                FieldType structFieldType = new FieldType(false, (ArrowType)new ArrowType.Struct(), null);
                Field structField = new Field("internal", structFieldType, Arrays.asList(keyField, valueField));
                ArrowType.Map arrowType4 = new ArrowType.Map(false);
                if (name == null) {
                    name = AvroToArrowUtils.getDefaultFieldName((ArrowType)arrowType4);
                }
                return new Field(name, FieldType.nullable((ArrowType)arrowType4), Collections.singletonList(structField));
            }
            case RECORD: {
                ArrayList<Field> childFields = new ArrayList<Field>();
                for (int i = 0; i < schema.getFields().size(); ++i) {
                    Schema.Field field = (Schema.Field)schema.getFields().get(i);
                    Schema childSchema = field.schema();
                    childFields.add(AvroToArrowUtils.avroSchemaToField(childSchema, field.name(), config));
                }
                ArrowType.Struct arrowType5 = new ArrowType.Struct();
                if (name == null) {
                    name = AvroToArrowUtils.getDefaultFieldName((ArrowType)arrowType5);
                }
                return new Field(name, FieldType.nullable((ArrowType)arrowType5), childFields);
            }
            case ENUM: {
                DictionaryProvider.MapDictionaryProvider provider = config.getProvider();
                int current = provider.getDictionaryIds().size();
                int enumCount = schema.getEnumSymbols().size();
                ArrowType.Int indexType = DictionaryEncoder.getIndexType((int)enumCount);
                FieldType indexFieldType = new FieldType(true, (ArrowType)indexType, new DictionaryEncoding((long)current, false, indexType));
                return new Field(name, indexFieldType, null);
            }
            case STRING: {
                arrowType = new ArrowType.Utf8();
                break;
            }
            case FIXED: {
                arrowType = new ArrowType.FixedSizeBinary(schema.getFixedSize());
                break;
            }
            case INT: {
                arrowType = new ArrowType.Int(32, true);
                break;
            }
            case BOOLEAN: {
                arrowType = new ArrowType.Bool();
                break;
            }
            case LONG: {
                arrowType = new ArrowType.Int(64, true);
                break;
            }
            case FLOAT: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                break;
            }
            case DOUBLE: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                break;
            }
            case BYTES: {
                arrowType = new ArrowType.Binary();
                break;
            }
            case NULL: {
                arrowType = new ArrowType.Null();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (name == null) {
            name = AvroToArrowUtils.getDefaultFieldName((ArrowType)arrowType);
        }
        return Field.nullable((String)name, (ArrowType)arrowType);
    }

    private static Consumer createArrayConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        ListVector listVector;
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            listVector = (ListVector)field.createVector(config.getAllocator());
        } else {
            listVector = (ListVector)consumerVector;
        }
        FieldVector dataVector = listVector.getDataVector();
        Schema childSchema = schema.getElementType();
        Consumer delegate = AvroToArrowUtils.createConsumer(childSchema, childSchema.getName(), config, dataVector);
        return new AvroArraysConsumer(listVector, delegate);
    }

    private static Consumer createStructConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        StructVector structVector;
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            structVector = (StructVector)field.createVector(config.getAllocator());
        } else {
            structVector = (StructVector)consumerVector;
        }
        Consumer[] delegates = new Consumer[schema.getFields().size()];
        for (int i = 0; i < schema.getFields().size(); ++i) {
            Consumer delegate;
            Schema childSchema = ((Schema.Field)schema.getFields().get(i)).schema();
            delegates[i] = delegate = AvroToArrowUtils.createConsumer(childSchema, childSchema.getName(), config, (FieldVector)structVector.getChildrenFromFields().get(i));
        }
        return new AvroStructConsumer(structVector, delegates);
    }

    private static Consumer createEnumConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        BaseIntVector indexVector;
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            indexVector = (BaseIntVector)field.createVector(config.getAllocator());
        } else {
            indexVector = (BaseIntVector)consumerVector;
        }
        int valueCount = schema.getEnumSymbols().size();
        VarCharVector dictVector = new VarCharVector(name, config.getAllocator());
        dictVector.allocateNewSafe();
        dictVector.setValueCount(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            dictVector.set(i, ((String)schema.getEnumSymbols().get(i)).getBytes(StandardCharsets.UTF_8));
        }
        Dictionary dictionary = new Dictionary((FieldVector)dictVector, indexVector.getField().getDictionary());
        config.getProvider().put(dictionary);
        return new AvroEnumConsumer(indexVector);
    }

    private static Consumer createMapConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        MapVector mapVector;
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            mapVector = (MapVector)field.createVector(config.getAllocator());
        } else {
            mapVector = (MapVector)consumerVector;
        }
        StructVector structVector = (StructVector)mapVector.getDataVector();
        AvroStringConsumer keyConsumer = new AvroStringConsumer((VarCharVector)structVector.getChildrenFromFields().get(0));
        Consumer valueConsumer = AvroToArrowUtils.createConsumer(schema.getValueType(), schema.getValueType().getName(), config, (FieldVector)structVector.getChildrenFromFields().get(1));
        AvroStructConsumer internalConsumer = new AvroStructConsumer(structVector, new Consumer[]{keyConsumer, valueConsumer});
        return new AvroMapConsumer(mapVector, internalConsumer);
    }

    private static Consumer createUnionConsumer(Schema schema, String name, AvroToArrowConfig config, FieldVector consumerVector) {
        UnionVector unionVector;
        int size = schema.getTypes().size();
        long nullCount = schema.getTypes().stream().filter(s -> s.getType() == Schema.Type.NULL).count();
        if (size == 1) {
            Schema subSchema = (Schema)schema.getTypes().get(0);
            return AvroToArrowUtils.createConsumer(subSchema, name, config, consumerVector);
        }
        if (size == 2 && nullCount == 1L) {
            Schema nullSchema = schema.getTypes().stream().filter(s -> s.getType() == Schema.Type.NULL).findFirst().get();
            int nullIndex = schema.getTypes().indexOf(nullSchema);
            Schema subSchema = schema.getTypes().stream().filter(s -> s.getType() != Schema.Type.NULL).findFirst().get();
            Preconditions.checkNotNull((Object)subSchema, (Object)"schema should not be null.");
            return AvroToArrowUtils.createConsumer(subSchema, name, true, nullIndex, config, consumerVector);
        }
        if (consumerVector == null) {
            Field field = AvroToArrowUtils.avroSchemaToField(schema, name, config);
            unionVector = (UnionVector)field.createVector(config.getAllocator());
        } else {
            unionVector = (UnionVector)consumerVector;
        }
        List childVectors = unionVector.getChildrenFromFields();
        Consumer[] delegates = new Consumer[size];
        Types.MinorType[] types = new Types.MinorType[size];
        for (int i = 0; i < size; ++i) {
            Consumer delegate;
            FieldVector child = (FieldVector)childVectors.get(i);
            Schema subSchema = (Schema)schema.getTypes().get(i);
            delegates[i] = delegate = AvroToArrowUtils.createConsumer(subSchema, subSchema.getName(), config, child);
            types[i] = child.getMinorType();
        }
        return new AvroUnionsConsumer(unionVector, delegates, types);
    }

    private static Map<String, String> getMetaData(Schema schema) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        schema.getObjectProps().forEach((k, v) -> metadata.put((String)k, v.toString()));
        return metadata;
    }

    static VectorSchemaRoot avroToArrowVectors(Schema schema, Decoder decoder, AvroToArrowConfig config) throws IOException {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        Schema.Type type = schema.getType();
        if (type == Schema.Type.RECORD) {
            for (Schema.Field field : schema.getFields()) {
                Consumer consumer = AvroToArrowUtils.createConsumer(field.schema(), field.name(), config);
                consumers.add(consumer);
                vectors.add(consumer.getVector());
            }
        } else {
            Consumer consumer = AvroToArrowUtils.createConsumer(schema, "", config);
            consumers.add(consumer);
            vectors.add(consumer.getVector());
        }
        Preconditions.checkArgument((vectors.size() == consumers.size() ? 1 : 0) != 0, (Object)"vectors size not equals consumers size");
        List fields = vectors.stream().map(t -> t.getField()).collect(Collectors.toList());
        VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, 0);
        CompositeAvroConsumer compositeConsumer = new CompositeAvroConsumer(consumers);
        int valueCount = 0;
        try {
            while (true) {
                compositeConsumer.consume(decoder, root);
                ++valueCount;
            }
        }
        catch (EOFException eof) {
            root.setRowCount(valueCount);
        }
        catch (Exception e) {
            compositeConsumer.close();
            throw new RuntimeException("Error occurs while consume process.", e);
        }
        return root;
    }
}

