/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.InPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.InsertionSorter;
import org.apache.arrow.algorithm.sort.OffHeapIntStack;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.BaseFixedWidthVector;

public class FixedWidthInPlaceVectorSorter<V extends BaseFixedWidthVector>
implements InPlaceVectorSorter<V> {
    public static final int CHANGE_ALGORITHM_THRESHOLD = 15;
    static final int STOP_CHOOSING_PIVOT_THRESHOLD = 3;
    VectorValueComparator<V> comparator;
    V vec;
    V pivotBuffer;

    @Override
    public void sortInPlace(V vec, VectorValueComparator<V> comparator) {
        try {
            this.vec = vec;
            this.comparator = comparator;
            this.pivotBuffer = (BaseFixedWidthVector)vec.getField().createVector(vec.getAllocator());
            this.pivotBuffer.allocateNew(1);
            this.pivotBuffer.setValueCount(1);
            comparator.attachVectors(vec, this.pivotBuffer);
            this.quickSort();
        }
        finally {
            this.pivotBuffer.close();
        }
    }

    private void quickSort() {
        try (OffHeapIntStack rangeStack = new OffHeapIntStack(this.vec.getAllocator());){
            rangeStack.push(0);
            rangeStack.push(this.vec.getValueCount() - 1);
            while (!rangeStack.isEmpty()) {
                int high = rangeStack.pop();
                int low = rangeStack.pop();
                if (low >= high) continue;
                if (high - low < 15) {
                    InsertionSorter.insertionSort(this.vec, low, high, this.comparator, this.pivotBuffer);
                    continue;
                }
                int mid = this.partition(low, high);
                if (high - mid < mid - low) {
                    rangeStack.push(low);
                    rangeStack.push(mid - 1);
                    rangeStack.push(mid + 1);
                    rangeStack.push(high);
                    continue;
                }
                rangeStack.push(mid + 1);
                rangeStack.push(high);
                rangeStack.push(low);
                rangeStack.push(mid - 1);
            }
        }
    }

    void choosePivot(int low, int high) {
        if (high - low + 1 < 3) {
            this.pivotBuffer.copyFrom(low, 0, this.vec);
            return;
        }
        this.comparator.attachVector(this.vec);
        int mid = low + (high - low) / 2;
        int medianIdx = this.comparator.compare(low, mid) < 0 ? (this.comparator.compare(mid, high) < 0 ? mid : (this.comparator.compare(low, high) < 0 ? high : low)) : (this.comparator.compare(mid, high) > 0 ? mid : (this.comparator.compare(low, high) < 0 ? low : high));
        if (medianIdx != low) {
            this.pivotBuffer.copyFrom(medianIdx, 0, this.vec);
            this.vec.copyFrom(low, medianIdx, this.vec);
            this.vec.copyFrom(0, low, this.pivotBuffer);
        } else {
            this.pivotBuffer.copyFrom(low, 0, this.vec);
        }
        this.comparator.attachVectors(this.vec, this.pivotBuffer);
    }

    private int partition(int low, int high) {
        this.choosePivot(low, high);
        while (low < high) {
            while (low < high && this.comparator.compare(high, 0) >= 0) {
                --high;
            }
            this.vec.copyFrom(high, low, this.vec);
            while (low < high && this.comparator.compare(low, 0) <= 0) {
                ++low;
            }
            this.vec.copyFrom(low, high, this.vec);
        }
        this.vec.copyFrom(0, low, this.pivotBuffer);
        return low;
    }
}

