/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.ValueVector;

public final class VectorSearcher {
    public static final int SEARCH_FAIL_RESULT = -1;

    public static <V extends ValueVector> int binarySearch(V targetVector, VectorValueComparator<V> comparator, V keyVector, int keyIndex) {
        comparator.attachVectors(keyVector, targetVector);
        int low = 0;
        int high = targetVector.getValueCount() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            int cmp = comparator.compare(keyIndex, mid);
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static <V extends ValueVector> int linearSearch(V targetVector, VectorValueComparator<V> comparator, V keyVector, int keyIndex) {
        comparator.attachVectors(keyVector, targetVector);
        for (int i = 0; i < targetVector.getValueCount(); ++i) {
            if (comparator.compare(keyIndex, i) != 0) continue;
            return i;
        }
        return -1;
    }

    private VectorSearcher() {
    }
}

