/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManagerException;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.PasswordRuleViolationException;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.rest.api.model.ErrorMessage;
import org.apache.archiva.redback.rest.api.services.PasswordService;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.apache.archiva.redback.rest.services.utils.PasswordValidator;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="passwordService#rest")
public class DefaultPasswordService
implements PasswordService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SecuritySystem securitySystem;
    private HttpAuthenticator httpAuthenticator;
    private PasswordValidator passwordValidator;
    @Context
    private HttpServletRequest httpServletRequest;

    @Inject
    public DefaultPasswordService(SecuritySystem securitySystem, @Named(value="httpAuthenticator#basic") HttpAuthenticator httpAuthenticator, PasswordValidator passwordValidator) {
        this.securitySystem = securitySystem;
        this.httpAuthenticator = httpAuthenticator;
        this.passwordValidator = passwordValidator;
    }

    public org.apache.archiva.redback.rest.api.model.User changePasswordWithKey(String password, String passwordConfirmation, String key) throws RedbackServiceException {
        String principal = null;
        if (StringUtils.isEmpty((String)password)) {
            throw new RedbackServiceException("password cannot be empty", Response.Status.FORBIDDEN.getStatusCode());
        }
        if (StringUtils.isEmpty((String)passwordConfirmation)) {
            throw new RedbackServiceException("password confirmation cannot be empty", Response.Status.FORBIDDEN.getStatusCode());
        }
        if (!StringUtils.equals((String)password, (String)passwordConfirmation)) {
            throw new RedbackServiceException("password confirmation must be same as password", Response.Status.FORBIDDEN.getStatusCode());
        }
        try {
            AuthenticationKey authKey = this.securitySystem.getKeyManager().findKey(key);
            principal = authKey.getForPrincipal();
            String encodedPassword = this.passwordValidator.validatePassword(password, principal);
            User user = this.securitySystem.getUserManager().findUser(principal, false);
            user.setPassword(password);
            user.setEncodedPassword(encodedPassword);
            user = this.securitySystem.getUserManager().updateUser(user);
            return new org.apache.archiva.redback.rest.api.model.User(user);
        }
        catch (KeyManagerException e) {
            this.log.info("issue to find key {}: {}", (Object)key, (Object)e.getMessage());
            throw new RedbackServiceException("issue with key", Response.Status.FORBIDDEN.getStatusCode());
        }
        catch (UserNotFoundException e) {
            this.log.info("user {} not found", (Object)e.getMessage());
            ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(2);
            ErrorMessage errorMessage = new ErrorMessage("cannot.update.user.not.found", new String[]{principal});
            errorMessages.add(errorMessage);
            errorMessage = new ErrorMessage("admin.deleted.account");
            errorMessages.add(errorMessage);
            throw new RedbackServiceException(errorMessages);
        }
        catch (UserManagerException e) {
            this.log.info("UserManagerException: {}", (Object)e.getMessage());
            List<ErrorMessage> errorMessages = Arrays.asList(new ErrorMessage().message("UserManagerException: " + e.getMessage()));
            throw new RedbackServiceException(errorMessages);
        }
        catch (PasswordRuleViolationException e) {
            PasswordRuleViolations violations = e.getViolations();
            ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(violations.getViolations().size());
            if (violations != null) {
                for (String violation : violations.getLocalizedViolations()) {
                    errorMessages.add(new ErrorMessage(violation));
                }
            }
            throw new RedbackServiceException(errorMessages);
        }
    }

    public org.apache.archiva.redback.rest.api.model.User changePassword(String userName, String previousPassword, String password, String passwordConfirmation) throws RedbackServiceException {
        if (StringUtils.isEmpty((String)userName)) {
            throw new RedbackServiceException(new ErrorMessage("username.cannot.be.empty"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        if (StringUtils.isEmpty((String)previousPassword)) {
            throw new RedbackServiceException(new ErrorMessage("password.previous.empty"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        if (StringUtils.isEmpty((String)password)) {
            throw new RedbackServiceException(new ErrorMessage("password.empty"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        if (StringUtils.isEmpty((String)passwordConfirmation)) {
            throw new RedbackServiceException(new ErrorMessage("password.confirmation.empty"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        if (!StringUtils.equals((String)password, (String)passwordConfirmation)) {
            throw new RedbackServiceException(new ErrorMessage("password.confirmation.same"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        try {
            User u = this.securitySystem.getUserManager().findUser(userName);
            String previousEncodedPassword = u.getEncodedPassword();
            PasswordEncoder encoder = this.securitySystem.getPolicy().getPasswordEncoder();
            if (!encoder.isPasswordValid(previousEncodedPassword, previousPassword)) {
                throw new RedbackServiceException(new ErrorMessage("password.provided.does.not.match.existing"), Response.Status.BAD_REQUEST.getStatusCode());
            }
            u.setPassword(password);
            u = this.securitySystem.getUserManager().updateUser(u);
            return new org.apache.archiva.redback.rest.api.model.User(u);
        }
        catch (UserNotFoundException e) {
            throw new RedbackServiceException(new ErrorMessage("user.not.found"), Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (UserManagerException e) {
            this.log.info("UserManagerException: {}", (Object)e.getMessage());
            List<ErrorMessage> errorMessages = Arrays.asList(new ErrorMessage().message("UserManagerException: " + e.getMessage()));
            throw new RedbackServiceException(errorMessages);
        }
    }
}

