/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.PasswordRuleViolationException;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.rest.api.model.ErrorMessage;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="passwordValidator#rest")
public class PasswordValidator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private SecuritySystem securitySystem;

    public String validatePassword(String password, String principal) throws RedbackServiceException {
        try {
            User tempUser = this.securitySystem.getUserManager().createUser("temp", "temp", "temp");
            tempUser.setPassword(password);
            this.securitySystem.getPolicy().validatePassword(tempUser);
            PasswordEncoder encoder = this.securitySystem.getPolicy().getPasswordEncoder();
            User user = this.securitySystem.getUserManager().findUser(principal);
            String encodedPassword = encoder.encodePassword(password);
            user.setEncodedPassword(encodedPassword);
            user.setPassword(password);
            this.securitySystem.getPolicy().validatePassword(user);
            return encodedPassword;
        }
        catch (UserNotFoundException e) {
            this.log.info("user {} not found", (Object)e.getMessage());
            ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(2);
            ErrorMessage errorMessage = new ErrorMessage("cannot.update.user.not.found", new String[]{principal});
            errorMessages.add(errorMessage);
            errorMessage = new ErrorMessage("admin.deleted.account");
            errorMessages.add(errorMessage);
            throw new RedbackServiceException(errorMessages);
        }
        catch (PasswordRuleViolationException e) {
            PasswordRuleViolations violations = e.getViolations();
            ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(violations.getViolations().size());
            if (violations != null) {
                for (String violation : violations.getLocalizedViolations()) {
                    errorMessages.add(new ErrorMessage(violation));
                }
            }
            throw new RedbackServiceException(errorMessages);
        }
        catch (UserManagerException e) {
            this.log.info("UserManagerException: {}", (Object)e.getMessage());
            List<ErrorMessage> errorMessages = Arrays.asList(new ErrorMessage().message("UserManagerException: " + e.getMessage()));
            throw new RedbackServiceException(errorMessages);
        }
    }
}

