/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.services.interceptors;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Context
    private HttpServletRequest httpServletRequest;
    @Context
    private HttpServletResponse httpServletResponse;

    public HttpServletRequest getHttpServletRequest(Message message) {
        return this.httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse(Message message) {
        return this.httpServletResponse;
    }

    public RedbackAuthorization getRedbackAuthorization(Message message) {
        OperationResourceInfo operationResourceInfo = (OperationResourceInfo)message.getExchange().get(OperationResourceInfo.class);
        if (operationResourceInfo == null) {
            return null;
        }
        Method method = operationResourceInfo.getAnnotatedMethod();
        RedbackAuthorization redbackAuthorization = method.getAnnotation(RedbackAuthorization.class);
        this.log.debug("class {}, resourceClass {}, method {}, redbackAuthorization {}", new Object[]{operationResourceInfo.getClassResourceInfo().getServiceClass(), operationResourceInfo.getClassResourceInfo().getResourceClass(), method, redbackAuthorization});
        return redbackAuthorization;
    }
}

