/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.common.ldap.connection;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;
import org.apache.archiva.redback.common.ldap.connection.DefaultLdapConnection;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionConfiguration;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.connection.LdapException;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ldapConnectionFactory#configurable")
public class ConfigurableLdapConnectionFactory
implements LdapConnectionFactory {
    private final Logger log = LoggerFactory.getLogger(ConfigurableLdapConnectionFactory.class);
    private String hostname;
    private int port;
    private boolean ssl;
    private String baseDn;
    private String contextFactory;
    private String bindDn;
    private String password;
    private String authenticationMethod;
    private Properties extraProperties;
    private LdapConnectionConfiguration ldapConnectionConfiguration;
    private boolean valid = false;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration userConf;

    @Override
    @PostConstruct
    public void initialize() {
        try {
            this.ldapConnectionConfiguration = new LdapConnectionConfiguration();
            this.ldapConnectionConfiguration.setHostname(this.userConf.getString("ldap.config.hostname", this.hostname));
            this.ldapConnectionConfiguration.setPort(this.userConf.getInt("ldap.config.port", this.port));
            this.ldapConnectionConfiguration.setSsl(this.userConf.getBoolean("ldap.config.ssl", this.ssl));
            this.ldapConnectionConfiguration.setBaseDn(this.userConf.getConcatenatedList("ldap.config.base.dn", this.baseDn));
            this.ldapConnectionConfiguration.setContextFactory(this.userConf.getString("ldap.config.context.factory", this.contextFactory));
            this.ldapConnectionConfiguration.setBindDn(this.userConf.getConcatenatedList("ldap.config.bind.dn", this.bindDn));
            this.ldapConnectionConfiguration.setPassword(this.userConf.getString("ldap.config.password", this.password));
            this.ldapConnectionConfiguration.setAuthenticationMethod(this.userConf.getString("ldap.config.authentication.method", this.authenticationMethod));
            this.ldapConnectionConfiguration.setExtraProperties(this.extraProperties);
            this.valid = true;
        }
        catch (InvalidNameException e) {
            this.log.error("Error during initialization of LdapConnectionFactory " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DefaultLdapConnection getConnection() throws LdapException {
        return new DefaultLdapConnection(this.getLdapConnectionConfiguration(), null);
    }

    @Override
    public DefaultLdapConnection getConnection(Rdn subRdn) throws LdapException {
        return new DefaultLdapConnection(this.getLdapConnectionConfiguration(), subRdn);
    }

    @Override
    public DefaultLdapConnection getConnection(String bindDn, String password) throws LdapException {
        return new DefaultLdapConnection(this.getLdapConnectionConfiguration(), bindDn, password);
    }

    @Override
    public DefaultLdapConnection getConnection(LdapConnectionConfiguration ldapConnectionConfiguration) throws LdapException {
        return new DefaultLdapConnection(ldapConnectionConfiguration, null);
    }

    @Override
    public LdapName getBaseDnLdapName() throws LdapException {
        try {
            return new LdapName(this.baseDn);
        }
        catch (InvalidNameException e) {
            throw new LdapException("The base DN is not a valid name.", e);
        }
    }

    @Override
    public void addObjectFactory(Class<? extends ObjectFactory> objectFactoryClass) {
        this.getLdapConnectionConfiguration().getObjectFactories().add(objectFactoryClass);
    }

    @Override
    public void addStateFactory(Class<? extends StateFactory> stateFactoryClass) {
        this.getLdapConnectionConfiguration().getStateFactories().add(stateFactoryClass);
    }

    public String toString() {
        return "{ConfigurableLdapConnectionFactory: configuration: " + this.getLdapConnectionConfiguration() + "}";
    }

    public LdapConnectionConfiguration getLdapConnectionConfiguration() {
        return this.ldapConnectionConfiguration;
    }

    public void setLdapConnectionConfiguration(LdapConnectionConfiguration ldapConnectionConfiguration) {
        this.ldapConnectionConfiguration = ldapConnectionConfiguration;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public void setBindDn(String bindDn) {
        this.bindDn = bindDn;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties extraProperties) {
        this.extraProperties = extraProperties;
    }

    public UserConfiguration getUserConf() {
        return this.userConf;
    }

    public void setUserConf(UserConfiguration userConf) {
        this.userConf = userConf;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

