/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.common.ldap.role;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.common.ldap.MappingException;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapperConfiguration;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ldapRoleMapperConfiguration#default")
public class DefaultLdapRoleMapperConfiguration
implements LdapRoleMapperConfiguration {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, List<String>> ldapMappings = new HashMap<String, List<String>>();
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration userConf;

    @Override
    public void addLdapMapping(String ldapGroup, List<String> roles) throws MappingException {
        this.ldapMappings.put(ldapGroup, roles);
        this.log.warn("addLdapMapping implemented but only in memory save: group '{}' roles '{}'", (Object)ldapGroup, roles);
    }

    @Override
    public void removeLdapMapping(String group) {
        this.ldapMappings.remove(group);
    }

    @Override
    public void updateLdapMapping(String ldapGroup, List<String> roles) throws MappingException {
        this.ldapMappings.put(ldapGroup, roles);
        this.log.warn("updateLdapMapping implemented but only in memory save: group '{}' roles '{}'", (Object)ldapGroup, roles);
    }

    @Override
    public void setLdapGroupMappings(Map<String, List<String>> mappings) throws MappingException {
        this.log.warn("setLdapGroupMappings implemented but only in memory save");
        this.ldapMappings = mappings;
    }

    @Override
    public Map<String, Collection<String>> getLdapGroupMappings() {
        ArrayListMultimap map = ArrayListMultimap.create();
        Collection keys = this.userConf.getKeys();
        for (String string : keys) {
            String[] roles;
            if (!string.startsWith("ldap.config.groups.role.")) continue;
            String val = this.userConf.getString(string);
            for (String role : roles = StringUtils.split((String)val, (char)',')) {
                map.put((Object)StringUtils.substringAfter((String)string, (String)"ldap.config.groups.role."), (Object)role);
            }
        }
        for (Map.Entry entry : this.ldapMappings.entrySet()) {
            map.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        Map mappings = map.asMap();
        return mappings;
    }
}

