/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content.maven2;

import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.metadata.repository.storage.maven2.ArtifactMappingProvider;
import org.apache.archiva.metadata.repository.storage.maven2.Maven2RepositoryPathTranslator;
import org.apache.archiva.model.ArchivaArtifact;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.ProjectReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.content.PathParser;
import org.apache.archiva.repository.content.maven2.DefaultPathParser;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefaultRepositoryContent {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String MAVEN_METADATA = "maven-metadata.xml";
    protected static final char PATH_SEPARATOR = '/';
    protected static final char GROUP_SEPARATOR = '.';
    protected static final char ARTIFACT_SEPARATOR = '-';
    private RepositoryPathTranslator pathTranslator = new Maven2RepositoryPathTranslator();
    private PathParser defaultPathParser = new DefaultPathParser();
    @Inject
    protected List<? extends ArtifactMappingProvider> artifactMappingProviders;

    @PostConstruct
    protected void initialize() {
    }

    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        return this.defaultPathParser.toArtifactReference(path);
    }

    public String toMetadataPath(ProjectReference reference) {
        StringBuilder path = new StringBuilder();
        path.append(this.formatAsDirectory(reference.getGroupId())).append('/');
        path.append(reference.getArtifactId()).append('/');
        path.append(MAVEN_METADATA);
        return path.toString();
    }

    public String toMetadataPath(VersionedReference reference) {
        StringBuilder path = new StringBuilder();
        path.append(this.formatAsDirectory(reference.getGroupId())).append('/');
        path.append(reference.getArtifactId()).append('/');
        if (reference.getVersion() != null) {
            path.append(VersionUtil.getBaseVersion((String)reference.getVersion())).append('/');
        }
        path.append(MAVEN_METADATA);
        return path.toString();
    }

    public String toPath(ArchivaArtifact reference) {
        if (reference == null) {
            throw new IllegalArgumentException("ArchivaArtifact cannot be null");
        }
        String baseVersion = VersionUtil.getBaseVersion((String)reference.getVersion());
        return this.toPath(reference.getGroupId(), reference.getArtifactId(), baseVersion, reference.getVersion(), reference.getClassifier(), reference.getType());
    }

    public String toPath(ArtifactReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Artifact reference cannot be null");
        }
        if (reference.getVersion() != null) {
            String baseVersion = VersionUtil.getBaseVersion((String)reference.getVersion());
            return this.toPath(reference.getGroupId(), reference.getArtifactId(), baseVersion, reference.getVersion(), reference.getClassifier(), reference.getType());
        }
        return this.toPath(reference.getGroupId(), reference.getArtifactId(), null, null, reference.getClassifier(), reference.getType());
    }

    private String formatAsDirectory(String directory) {
        return directory.replace('.', '/');
    }

    private String toPath(String groupId, String artifactId, String baseVersion, String version, String classifier, String type) {
        if (baseVersion != null) {
            return this.pathTranslator.toPath(groupId, artifactId, baseVersion, this.constructId(artifactId, version, classifier, type));
        }
        return this.pathTranslator.toPath(groupId, artifactId);
    }

    private String constructId(String artifactId, String version, String classifier, String type) {
        ArtifactMappingProvider provider;
        String ext = null;
        Iterator<? extends ArtifactMappingProvider> iterator = this.artifactMappingProviders.iterator();
        while (iterator.hasNext() && (ext = (provider = iterator.next()).mapTypeToExtension(type)) == null) {
        }
        if (ext == null) {
            ext = type;
        }
        StringBuilder id = new StringBuilder();
        if (version != null && type != null) {
            id.append(artifactId).append('-').append(version);
            if (StringUtils.isNotBlank((String)classifier)) {
                id.append('-').append(classifier);
            }
            id.append(".").append(ext);
        }
        return id.toString();
    }
}

