/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.NetworkProxyService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.springframework.stereotype.Service;

@Service(value="networkProxyService#rest")
public class DefaultNetworkProxyService
extends AbstractRestService
implements NetworkProxyService {
    @Inject
    private NetworkProxyAdmin networkProxyAdmin;

    public List<NetworkProxy> getNetworkProxies() throws ArchivaRestServiceException {
        try {
            List networkProxies = this.networkProxyAdmin.getNetworkProxies();
            return networkProxies == null ? Collections.emptyList() : networkProxies;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public NetworkProxy getNetworkProxy(String networkProxyId) throws ArchivaRestServiceException {
        try {
            return this.networkProxyAdmin.getNetworkProxy(networkProxyId);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void addNetworkProxy(NetworkProxy networkProxy) throws ArchivaRestServiceException {
        try {
            if (networkProxy == null) {
                return;
            }
            this.getNetworkProxyAdmin().addNetworkProxy(networkProxy, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateNetworkProxy(NetworkProxy networkProxy) throws ArchivaRestServiceException {
        if (networkProxy == null) {
            return;
        }
        try {
            this.getNetworkProxyAdmin().updateNetworkProxy(networkProxy, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean deleteNetworkProxy(String networkProxyId) throws ArchivaRestServiceException {
        try {
            this.getNetworkProxyAdmin().deleteNetworkProxy(networkProxyId, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public NetworkProxyAdmin getNetworkProxyAdmin() {
        return this.networkProxyAdmin;
    }

    public void setNetworkProxyAdmin(NetworkProxyAdmin networkProxyAdmin) {
        this.networkProxyAdmin = networkProxyAdmin;
    }
}

