/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.maven;

import java.util.Map;
import java.util.Properties;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class BrokerMojo
extends AbstractMojo {
    protected MavenProject project;
    private String configUri;
    private boolean fork;
    private Properties systemProperties;

    public void execute() throws MojoExecutionException {
        try {
            this.setSystemProperties();
            this.getLog().info((CharSequence)("Loading broker configUri: " + this.configUri));
            final BrokerService broker = BrokerFactory.createBroker((String)this.configUri);
            if (this.fork) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            broker.start();
                            BrokerMojo.this.waitForShutdown(broker);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            } else {
                broker.start();
                this.waitForShutdown(broker);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to start ActiveMQ Broker", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForShutdown(BrokerService broker) throws Exception {
        final boolean[] shutdown = new boolean[]{false};
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean[] blArray = shutdown;
                synchronized (shutdown) {
                    shutdown[0] = true;
                    shutdown.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        boolean[] blArray = shutdown;
        synchronized (shutdown) {
            while (!shutdown[0]) {
                try {
                    shutdown.wait();
                }
                catch (InterruptedException e) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            broker.stop();
            return;
        }
    }

    protected void setSystemProperties() {
        System.setProperty("activemq.base", this.project.getBuild().getDirectory() + "/");
        System.setProperty("activemq.home", this.project.getBuild().getDirectory() + "/");
        System.setProperty("org.apache.activemq.UseDedicatedTaskRunner", "true");
        System.setProperty("org.apache.activemq.default.directory.prefix", this.project.getBuild().getDirectory() + "/");
        System.setProperty("derby.system.home", this.project.getBuild().getDirectory() + "/");
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        System.getProperties().putAll((Map<?, ?>)this.systemProperties);
    }
}

