/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.reports.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.tool.reports.PerformanceStatisticsUtil;
import org.apache.activemq.tool.reports.plugins.ReportPlugin;

public class ThroughputReportPlugin
implements ReportPlugin {
    public static final String KEY_SYS_TOTAL_TP = "SystemTotalTP";
    public static final String KEY_SYS_TOTAL_CLIENTS = "SystemTotalClients";
    public static final String KEY_SYS_AVE_TP = "SystemAveTP";
    public static final String KEY_SYS_AVE_EMM_TP = "SystemAveEMMTP";
    public static final String KEY_SYS_AVE_CLIENT_TP = "SystemAveClientTP";
    public static final String KEY_SYS_AVE_CLIENT_EMM_TP = "SystemAveClientEMMTP";
    public static final String KEY_MIN_CLIENT_TP = "MinClientTP";
    public static final String KEY_MAX_CLIENT_TP = "MaxClientTP";
    public static final String KEY_MIN_CLIENT_TOTAL_TP = "MinClientTotalTP";
    public static final String KEY_MAX_CLIENT_TOTAL_TP = "MaxClientTotalTP";
    public static final String KEY_MIN_CLIENT_AVE_TP = "MinClientAveTP";
    public static final String KEY_MAX_CLIENT_AVE_TP = "MaxClientAveTP";
    public static final String KEY_MIN_CLIENT_AVE_EMM_TP = "MinClientAveEMMTP";
    public static final String KEY_MAX_CLIENT_AVE_EMM_TP = "MaxClientAveEMMTP";
    protected Map<String, List> clientThroughputs = new HashMap<String, List>();

    @Override
    public void handleCsvData(String csvData) {
        StringTokenizer tokenizer = new StringTokenizer(csvData, ",");
        String clientName = null;
        Long throughput = null;
        while (tokenizer.hasMoreTokens()) {
            String data = tokenizer.nextToken();
            String key = data.substring(0, data.indexOf("="));
            String val = data.substring(data.indexOf("=") + 1);
            if (key.equalsIgnoreCase("clientName")) {
                clientName = val;
                continue;
            }
            if (!key.equalsIgnoreCase("throughput")) continue;
            throughput = Long.valueOf(val);
        }
        this.addToClientTPList(clientName, throughput);
    }

    @Override
    public Map<String, String> getSummary() {
        if (this.clientThroughputs.size() == 0) {
            return new HashMap<String, String>();
        }
        long minClientTP = Long.MAX_VALUE;
        long maxClientTP = Long.MIN_VALUE;
        long minClientTotalTP = Long.MAX_VALUE;
        long maxClientTotalTP = Long.MIN_VALUE;
        long systemTotalTP = 0L;
        double minClientAveTP = Double.MAX_VALUE;
        double maxClientAveTP = Double.MIN_VALUE;
        double minClientAveEMMTP = Double.MAX_VALUE;
        double maxClientAveEMMTP = Double.MIN_VALUE;
        double systemAveTP = 0.0;
        double systemAveEMMTP = 0.0;
        String nameMinClientTP = "";
        String nameMaxClientTP = "";
        String nameMinClientTotalTP = "";
        String nameMaxClientTotalTP = "";
        String nameMinClientAveTP = "";
        String nameMaxClientAveTP = "";
        String nameMinClientAveEMMTP = "";
        String nameMaxClientAveEMMTP = "";
        Set<String> clientNames = this.clientThroughputs.keySet();
        int clientCount = 0;
        for (String clientName : clientNames) {
            List clientTPList = this.clientThroughputs.get(clientName);
            ++clientCount;
            long tempLong = PerformanceStatisticsUtil.getMin(clientTPList);
            if (tempLong < minClientTP) {
                minClientTP = tempLong;
                nameMinClientTP = clientName;
            }
            if ((tempLong = PerformanceStatisticsUtil.getMax(clientTPList)) > maxClientTP) {
                maxClientTP = tempLong;
                nameMaxClientTP = clientName;
            }
            tempLong = PerformanceStatisticsUtil.getSum(clientTPList);
            systemTotalTP += tempLong;
            if (tempLong < minClientTotalTP) {
                minClientTotalTP = tempLong;
                nameMinClientTotalTP = clientName;
            }
            if (tempLong > maxClientTotalTP) {
                maxClientTotalTP = tempLong;
                nameMaxClientTotalTP = clientName;
            }
            double tempDouble = PerformanceStatisticsUtil.getAve(clientTPList);
            systemAveTP += tempDouble;
            if (tempDouble < minClientAveTP) {
                minClientAveTP = tempDouble;
                nameMinClientAveTP = clientName;
            }
            if (tempDouble > maxClientAveTP) {
                maxClientAveTP = tempDouble;
                nameMaxClientAveTP = clientName;
            }
            tempDouble = PerformanceStatisticsUtil.getAveEx(clientTPList);
            systemAveEMMTP += tempDouble;
            if (tempDouble < minClientAveEMMTP) {
                minClientAveEMMTP = tempDouble;
                nameMinClientAveEMMTP = clientName;
            }
            if (!(tempDouble > maxClientAveEMMTP)) continue;
            maxClientAveEMMTP = tempDouble;
            nameMaxClientAveEMMTP = clientName;
        }
        HashMap<String, String> summary = new HashMap<String, String>();
        summary.put(KEY_SYS_TOTAL_TP, String.valueOf(systemTotalTP));
        summary.put(KEY_SYS_TOTAL_CLIENTS, String.valueOf(clientCount));
        summary.put(KEY_SYS_AVE_TP, String.valueOf(systemAveTP));
        summary.put(KEY_SYS_AVE_EMM_TP, String.valueOf(systemAveEMMTP));
        summary.put(KEY_SYS_AVE_CLIENT_TP, String.valueOf(systemAveTP / (double)clientCount));
        summary.put(KEY_SYS_AVE_CLIENT_EMM_TP, String.valueOf(systemAveEMMTP / (double)clientCount));
        summary.put(KEY_MIN_CLIENT_TP, nameMinClientTP + "=" + minClientTP);
        summary.put(KEY_MAX_CLIENT_TP, nameMaxClientTP + "=" + maxClientTP);
        summary.put(KEY_MIN_CLIENT_TOTAL_TP, nameMinClientTotalTP + "=" + minClientTotalTP);
        summary.put(KEY_MAX_CLIENT_TOTAL_TP, nameMaxClientTotalTP + "=" + maxClientTotalTP);
        summary.put(KEY_MIN_CLIENT_AVE_TP, nameMinClientAveTP + "=" + minClientAveTP);
        summary.put(KEY_MAX_CLIENT_AVE_TP, nameMaxClientAveTP + "=" + maxClientAveTP);
        summary.put(KEY_MIN_CLIENT_AVE_EMM_TP, nameMinClientAveEMMTP + "=" + minClientAveEMMTP);
        summary.put(KEY_MAX_CLIENT_AVE_EMM_TP, nameMaxClientAveEMMTP + "=" + maxClientAveEMMTP);
        return summary;
    }

    protected void addToClientTPList(String clientName, Long throughput) {
        if (clientName == null || throughput == null) {
            throw new IllegalArgumentException("Invalid Throughput CSV Data: clientName=" + clientName + ", throughput=" + throughput);
        }
        ArrayList<Long> clientTPList = this.clientThroughputs.get(clientName);
        if (clientTPList == null) {
            clientTPList = new ArrayList<Long>();
            this.clientThroughputs.put(clientName, clientTPList);
        }
        clientTPList.add(throughput);
    }
}

