/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import javax.jms.JMSException;
import org.apache.activemq.tool.AbstractJmsClientSystem;
import org.apache.activemq.tool.JmsConsumerClient;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.apache.activemq.tool.properties.JmsClientSystemProperties;
import org.apache.activemq.tool.properties.JmsConsumerProperties;
import org.apache.activemq.tool.properties.JmsConsumerSystemProperties;
import org.apache.activemq.tool.sampler.ThroughputSamplerTask;

public class JmsConsumerSystem
extends AbstractJmsClientSystem {
    protected JmsConsumerSystemProperties sysTest = new JmsConsumerSystemProperties();
    protected JmsConsumerProperties consumer = new JmsConsumerProperties();

    @Override
    public JmsClientSystemProperties getSysTest() {
        return this.sysTest;
    }

    @Override
    public void setSysTest(JmsClientSystemProperties sysTestProps) {
        this.sysTest = (JmsConsumerSystemProperties)sysTestProps;
    }

    @Override
    public JmsClientProperties getJmsClientProperties() {
        return this.getConsumer();
    }

    public JmsConsumerProperties getConsumer() {
        return this.consumer;
    }

    public void setConsumer(JmsConsumerProperties consumer) {
        this.consumer = consumer;
    }

    @Override
    protected void runJmsClient(String clientName, int clientDestIndex, int clientDestCount) {
        ThroughputSamplerTask sampler = this.getTpSampler();
        JmsConsumerClient consumerClient = new JmsConsumerClient(this.consumer, this.jmsConnFactory);
        consumerClient.setClientName(clientName);
        if (sampler != null) {
            sampler.registerClient(consumerClient);
        }
        try {
            consumerClient.receiveMessages(clientDestIndex, clientDestCount);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JmsConsumerSystem sys = new JmsConsumerSystem();
        sys.configureProperties(AbstractJmsClientSystem.parseStringArgs(args));
        try {
            sys.runSystemTest();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

