/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.sampler;

import java.io.IOException;
import org.apache.activemq.tool.sampler.AbstractPerformanceSampler;
import org.apache.activemq.tool.sampler.plugins.CpuSamplerPlugin;
import org.apache.activemq.tool.sampler.plugins.LinuxCpuSamplerPlugin;

public class CpuSamplerTask
extends AbstractPerformanceSampler {
    private CpuSamplerPlugin plugin;

    public void createPlugin() throws IOException {
        this.createPlugin(System.getProperty("os.name"));
    }

    public void createPlugin(String osName) throws IOException {
        if (osName == null) {
            throw new IOException("No defined OS name found. Found: " + osName);
        }
        if (!osName.equalsIgnoreCase("Linux")) {
            throw new IOException("No CPU Sampler Plugin found for OS: " + osName + ". CPU Sampler will not be started.");
        }
        this.plugin = new LinuxCpuSamplerPlugin(this.getInterval());
    }

    public void sampleData() {
        if (this.plugin != null && this.perfReportWriter != null) {
            this.perfReportWriter.writeCsvData(1, "index=" + this.sampleIndex + "," + this.plugin.getCpuUtilizationStats());
        }
    }

    protected void onRampUpStart() {
        super.onRampUpStart();
        if (this.plugin != null) {
            this.plugin.start();
        }
    }

    protected void onRampDownEnd() {
        super.onRampDownEnd();
        if (this.plugin != null) {
            this.plugin.stop();
        }
    }
}

