/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.reports.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.activemq.tool.reports.PerformanceStatisticsUtil;
import org.apache.activemq.tool.reports.plugins.ReportPlugin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuReportPlugin
implements ReportPlugin {
    public static final String NAME_IGNORE_LIST = "$index$timeUnit$r$b$w$swpd$inact$active$free$buff$cache$si$so$in$";
    public static final String NAME_BLOCK_RECV = "bi";
    public static final String NAME_BLOCK_SENT = "bo";
    public static final String NAME_CTX_SWITCH = "cs";
    public static final String NAME_USER_TIME = "us";
    public static final String NAME_SYS_TIME = "sy";
    public static final String NAME_IDLE_TIME = "id";
    public static final String NAME_WAIT_TIME = "wa";
    public static final String KEY_BLOCK_RECV = "BlocksReceived";
    public static final String KEY_BLOCK_SENT = "BlocksSent";
    public static final String KEY_CTX_SWITCH = "ContextSwitches";
    public static final String KEY_USER_TIME = "UserTime";
    public static final String KEY_SYS_TIME = "SystemTime";
    public static final String KEY_IDLE_TIME = "IdleTime";
    public static final String KEY_WAIT_TIME = "WaitingTime";
    public static final String KEY_AVE_BLOCK_RECV = "AveBlocksReceived";
    public static final String KEY_AVE_BLOCK_SENT = "AveBlocksSent";
    public static final String KEY_AVE_CTX_SWITCH = "AveContextSwitches";
    public static final String KEY_AVE_USER_TIME = "AveUserTime";
    public static final String KEY_AVE_SYS_TIME = "AveSystemTime";
    public static final String KEY_AVE_IDLE_TIME = "AveIdleTime";
    public static final String KEY_AVE_WAIT_TIME = "AveWaitingTime";
    private static final Log LOG = LogFactory.getLog(CpuReportPlugin.class);
    protected List<Long> blockRecv = new ArrayList<Long>();
    protected List<Long> blockSent = new ArrayList<Long>();
    protected List<Long> ctxSwitch = new ArrayList<Long>();
    protected List<Long> userTime = new ArrayList<Long>();
    protected List<Long> sysTime = new ArrayList<Long>();
    protected List<Long> idleTime = new ArrayList<Long>();
    protected List<Long> waitTime = new ArrayList<Long>();

    @Override
    public void handleCsvData(String csvData) {
        StringTokenizer tokenizer = new StringTokenizer(csvData, ",");
        while (tokenizer.hasMoreTokens()) {
            String data = tokenizer.nextToken();
            String key = data.substring(0, data.indexOf("="));
            String val = data.substring(data.indexOf("=") + 1);
            this.addToCpuList(key, val);
        }
    }

    @Override
    public Map<String, String> getSummary() {
        long val;
        HashMap<String, String> summary = new HashMap<String, String>();
        if (this.blockRecv.size() > 0) {
            val = PerformanceStatisticsUtil.getSum(this.blockRecv);
            summary.put(KEY_BLOCK_RECV, String.valueOf(val));
            summary.put(KEY_AVE_BLOCK_RECV, String.valueOf((double)val / (double)this.blockRecv.size()));
        }
        if (this.blockSent.size() > 0) {
            val = PerformanceStatisticsUtil.getSum(this.blockSent);
            summary.put(KEY_BLOCK_SENT, String.valueOf(val));
            summary.put(KEY_AVE_BLOCK_SENT, String.valueOf((double)val / (double)this.blockSent.size()));
        }
        if (this.ctxSwitch.size() > 0) {
            val = PerformanceStatisticsUtil.getSum(this.ctxSwitch);
            summary.put(KEY_CTX_SWITCH, String.valueOf(val));
            summary.put(KEY_AVE_CTX_SWITCH, String.valueOf((double)val / (double)this.ctxSwitch.size()));
        }
        if (this.userTime.size() > 0) {
            val = PerformanceStatisticsUtil.getSum(this.userTime);
            summary.put(KEY_USER_TIME, String.valueOf(val));
            summary.put(KEY_AVE_USER_TIME, String.valueOf((double)val / (double)this.userTime.size()));
        }
        if (this.sysTime.size() > 0) {
            val = PerformanceStatisticsUtil.getSum(this.sysTime);
            summary.put(KEY_SYS_TIME, String.valueOf(val));
            summary.put(KEY_AVE_SYS_TIME, String.valueOf((double)val / (double)this.sysTime.size()));
        }
        if (this.idleTime.size() > 0) {
            val = PerformanceStatisticsUtil.getSum(this.idleTime);
            summary.put(KEY_IDLE_TIME, String.valueOf(val));
            summary.put(KEY_AVE_IDLE_TIME, String.valueOf((double)val / (double)this.idleTime.size()));
        }
        if (this.waitTime.size() > 0) {
            val = PerformanceStatisticsUtil.getSum(this.waitTime);
            summary.put(KEY_WAIT_TIME, String.valueOf(val));
            summary.put(KEY_AVE_WAIT_TIME, String.valueOf((double)val / (double)this.waitTime.size()));
        }
        if (summary.size() > 0) {
            return summary;
        }
        return null;
    }

    protected void addToCpuList(String key, String val) {
        if (key.equals(NAME_BLOCK_RECV)) {
            this.blockRecv.add(Long.valueOf(val));
        } else if (key.equals(NAME_BLOCK_SENT)) {
            this.blockSent.add(Long.valueOf(val));
        } else if (key.equals(NAME_CTX_SWITCH)) {
            this.ctxSwitch.add(Long.valueOf(val));
        } else if (key.equals(NAME_USER_TIME)) {
            this.userTime.add(Long.valueOf(val));
        } else if (key.equals(NAME_SYS_TIME)) {
            this.sysTime.add(Long.valueOf(val));
        } else if (key.equals(NAME_IDLE_TIME)) {
            this.idleTime.add(Long.valueOf(val));
        } else if (key.equals(NAME_WAIT_TIME)) {
            this.waitTime.add(Long.valueOf(val));
        } else if (NAME_IGNORE_LIST.indexOf("$" + key + "$") == -1) {
            LOG.warn((Object)("Unrecognized CPU data. " + key + "=" + val));
        }
    }
}

