/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.sampler;

import org.apache.activemq.tool.sampler.PerformanceSampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RampDownNotifier
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RampDownNotifier.class);
    private final PerformanceSampler sampler;

    public RampDownNotifier(PerformanceSampler sampler) {
        this.sampler = sampler;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.sampler.getDuration() - this.sampler.getRampDownTime());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            LOG.debug("Ramping down sampler");
            this.sampler.finishSampling();
        }
    }
}

