/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.apache.activemq.tool.properties.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsProducerProperties
extends JmsClientProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtil.class);
    public static final String TIME_BASED_SENDING = "time";
    public static final String COUNT_BASED_SENDING = "count";
    public static final String DELIVERY_MODE_PERSISTENT = "persistent";
    public static final String DELIVERY_MODE_NON_PERSISTENT = "nonpersistent";
    protected String deliveryMode = "nonpersistent";
    protected int messageSize = 1024;
    protected long sendCount = 1000000L;
    protected long sendDuration = 300000L;
    protected String sendType = "time";
    protected long sendDelay = 0L;
    protected String msgFileName = null;
    protected Map<String, Object> headerMap = new HashMap<String, Object>();
    protected boolean createNewMsg;

    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public long getSendCount() {
        return this.sendCount;
    }

    public void setSendCount(long sendCount) {
        this.sendCount = sendCount;
    }

    public long getSendDuration() {
        return this.sendDuration;
    }

    public void setSendDuration(long sendDuration) {
        this.sendDuration = sendDuration;
    }

    public String getSendType() {
        return this.sendType;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }

    public boolean isCreateNewMsg() {
        return this.createNewMsg;
    }

    public void setCreateNewMsg(boolean createNewMsg) {
        this.createNewMsg = createNewMsg;
    }

    public void setSendDelay(long delay) {
        this.sendDelay = delay;
    }

    public long getSendDelay() {
        return this.sendDelay;
    }

    public void setHeader(String encodedHeader) {
        String[] headers;
        if (encodedHeader.endsWith(":")) {
            encodedHeader = encodedHeader.substring(0, encodedHeader.length() - 1);
        }
        for (String h : headers = encodedHeader.split(":")) {
            String[] tokens = h.split("=");
            if (tokens.length != 2 || tokens[0].equals("") || tokens[1].equals("")) {
                LOG.error("Error parsing message headers. Header: \"" + h + "\". This header will be ignored.");
                continue;
            }
            this.headerMap.put(tokens[0], tokens[1]);
        }
    }

    public Set<String> getHeaderKeys() {
        return this.headerMap.keySet();
    }

    public Object getHeaderValue(String key) {
        return this.headerMap.get(key);
    }

    public void clearHeaders() {
        this.headerMap.clear();
    }

    public void setMsgFileName(String file) {
        LOG.info("\"producer.msgFileName\" specified. Will ignore setting \"producer.messageSize\".");
        this.msgFileName = file;
    }

    public String getMsgFileName() {
        return this.msgFileName;
    }
}

